/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.YangAppErrorHolder;
import org.onosproject.yangutils.datamodel.YangAppErrorInfo;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangCommonInfo;
import org.onosproject.yangutils.datamodel.YangConfig;
import org.onosproject.yangutils.datamodel.YangIfFeature;
import org.onosproject.yangutils.datamodel.YangIfFeatureHolder;
import org.onosproject.yangutils.datamodel.YangIsFilterContentNodes;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangStatusType;
import org.onosproject.yangutils.datamodel.YangWhen;
import org.onosproject.yangutils.datamodel.YangWhenHolder;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.exceptions.ErrorMessages;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;

public abstract class YangChoice
extends YangNode
implements YangCommonInfo,
Parsable,
CollisionDetector,
YangAugmentableNode,
YangWhenHolder,
YangIfFeatureHolder,
YangAppErrorHolder,
YangIsFilterContentNodes,
YangConfig {
    private static final long serialVersionUID = 806201604L;
    private boolean isConfig;
    private String description;
    private String mandatory;
    private String reference;
    private YangStatusType status;
    private String defaultValueInString;
    private YangWhen when;
    private List<YangIfFeature> ifFeatureList;
    private final List<YangAugment> yangAugmentedInfo;
    private YangAppErrorInfo yangAppErrorInfo = new YangAppErrorInfo();

    public YangChoice() {
        super(YangNodeType.CHOICE_NODE, new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>());
        this.ifFeatureList = new LinkedList<YangIfFeature>();
        this.yangAugmentedInfo = new ArrayList<YangAugment>();
        this.yangAppErrorInfo.setErrorTag("data-missing");
        this.yangAppErrorInfo.setErrorAppTag("missing-choice");
        this.yangAppErrorInfo.setErrorAppPath("Path to the element with the missing choice.");
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo context) throws DataModelException {
        this.getYsnContextInfoMap().put(id, context);
        YangSchemaNodeContextInfo contextInfo = new YangSchemaNodeContextInfo();
        contextInfo.setSchemaNode(context.getSchemaNode());
        contextInfo.setContextSwitchedNode(this);
        this.getParent().addToChildSchemaMap(id, contextInfo);
    }

    @Override
    public void setNameSpaceAndAddToParentSchemaMap() {
        this.setNameSpace(this.getParent().getNameSpace());
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier yangSchemaNodeIdentifier, YangSchemaNode yangSchemaNode) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_CHOICE_NODE;
    }

    @Override
    public YangWhen getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(YangWhen when) {
        this.when = when;
    }

    @Override
    public boolean isConfig() {
        return this.isConfig;
    }

    @Override
    public void setConfig(boolean isConfig) {
        this.isConfig = isConfig;
    }

    public String getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(String mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    public String getDefaultValueInString() {
        return this.defaultValueInString;
    }

    public void setDefaultValueInString(String defaultValueInString) {
        this.defaultValueInString = defaultValueInString;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.CHOICE_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
        if (this.defaultValueInString != null && !this.defaultValueInString.isEmpty()) {
            boolean matched = false;
            for (YangNode node = this.getChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof YangCase) || !this.defaultValueInString.equals(node.getName())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                throw new DataModelException("YANG file error: default string \"" + this.defaultValueInString + "\" not matching choice \"" + this.getName() + "\" case.");
            }
        }
    }

    @Override
    public void detectCollidingChild(String idName, YangConstructType type) throws DataModelException {
        if (this.getParent() instanceof YangCase && type != YangConstructType.CASE_DATA) {
            ((CollisionDetector)((Object)this.getParent())).detectCollidingChild(idName, type);
        }
        for (YangNode node = this.getChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof CollisionDetector)) continue;
            ((CollisionDetector)((Object)node)).detectSelfCollision(idName, type);
        }
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (dataType == YangConstructType.CHOICE_DATA) {
            if (this.getName().equals(identifierName)) {
                throw new DataModelException(ErrorMessages.getErrorMsgCollision("YANG File Error: Identifier collision detected in", this.getName(), this.getLineNumber(), this.getCharPosition(), " choice ", this.getFileName()));
            }
            return;
        }
        for (YangNode node = this.getChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof CollisionDetector)) continue;
            ((CollisionDetector)((Object)node)).detectSelfCollision(identifierName, dataType);
        }
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return Collections.unmodifiableList(this.ifFeatureList);
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        this.ifFeatureList.add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public void addAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.add(augmentInfo);
    }

    @Override
    public void removeAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.remove(augmentInfo);
    }

    @Override
    public List<YangAugment> getAugmentedInfoList() {
        return Collections.unmodifiableList(this.yangAugmentedInfo);
    }

    @Override
    public void setAppErrorInfo(YangAppErrorInfo yangAppErrorInfo) {
        this.yangAppErrorInfo = yangAppErrorInfo;
    }

    @Override
    public YangAppErrorInfo getAppErrorInfo() {
        return this.yangAppErrorInfo;
    }
}

