/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;

public final class FractionDigits
extends DefaultLocationInfo {
    private static ArrayList<Range> decimal64ValueRange = null;

    private FractionDigits() {
    }

    public static ArrayList<Range> getDecimal64ValueRange() {
        if (decimal64ValueRange == null) {
            decimal64ValueRange = new ArrayList();
            decimal64ValueRange.add(new Range(-9.223372036854776E17, 9.223372036854776E17));
            decimal64ValueRange.add(new Range(-9.223372036854776E16, 9.223372036854776E16));
            decimal64ValueRange.add(new Range(-9.223372036854776E15, 9.223372036854776E15));
            decimal64ValueRange.add(new Range(-9.223372036854776E14, 9.223372036854776E14));
            decimal64ValueRange.add(new Range(-9.223372036854777E13, 9.223372036854777E13));
            decimal64ValueRange.add(new Range(-9.223372036854775E12, 9.223372036854775E12));
            decimal64ValueRange.add(new Range(-9.223372036854775E11, 9.223372036854775E11));
            decimal64ValueRange.add(new Range(-9.223372036854776E10, 9.223372036854776E10));
            decimal64ValueRange.add(new Range(-9.223372036854776E9, 9.223372036854776E9));
            decimal64ValueRange.add(new Range(-9.223372036854776E8, 9.223372036854776E8));
            decimal64ValueRange.add(new Range(-9.223372036854775E7, 9.223372036854775E7));
            decimal64ValueRange.add(new Range(-9223372.036854776, 9223372.036854776));
            decimal64ValueRange.add(new Range(-922337.2036854776, 922337.2036854776));
            decimal64ValueRange.add(new Range(-92233.72036854776, 92233.72036854776));
            decimal64ValueRange.add(new Range(-9223.372036854777, 9223.372036854777));
            decimal64ValueRange.add(new Range(-922.3372036854776, 922.3372036854776));
            decimal64ValueRange.add(new Range(-92.23372036854776, 92.23372036854776));
            decimal64ValueRange.add(new Range(-9.223372036854776, 9.223372036854776));
        }
        return decimal64ValueRange;
    }

    public static Range getRange(int fractionDigit) throws DataModelException {
        if (fractionDigit < 1 || fractionDigit > 18) {
            throw new DataModelException("YANG file error : given fraction-digit is not in its range (1..18).");
        }
        return FractionDigits.getDecimal64ValueRange().get(fractionDigit - 1);
    }

    public static boolean isValueInDecimal64Range(BigDecimal value, int fractionDigit) {
        if (fractionDigit < 1 || fractionDigit > 18) {
            return false;
        }
        Range range = FractionDigits.getDecimal64ValueRange().get(fractionDigit - 1);
        return value.doubleValue() >= range.getMin() && value.doubleValue() <= range.getMax();
    }

    public static class Range {
        private double min;
        private double max;

        protected Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

