/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangBits;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.YangUnion;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class BitsListener {
    private BitsListener() {
    }

    public static void processBitsEntry(TreeWalkListener listener, GeneratedYangParser.BitsSpecificationContext ctx) {
        Parsable typeData;
        YangBits bitsNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BITS_DATA, "", ListenerErrorLocation.ENTRY);
        if (listener.getParsedDataStack().peek() instanceof YangType) {
            bitsNode = new YangBits();
            bitsNode.setLineNumber(ctx.getStart().getLine());
            bitsNode.setCharPosition(ctx.getStart().getCharPositionInLine());
            bitsNode.setFileName(listener.getFileName());
            typeData = listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BITS_DATA, "", ListenerErrorLocation.ENTRY);
            Parsable tmpData = listener.getParsedDataStack().peek();
            switch (tmpData.getYangConstructType()) {
                case LEAF_DATA: {
                    bitsNode.setBitsName(((YangLeaf)tmpData).getName());
                    break;
                }
                case LEAF_LIST_DATA: {
                    bitsNode.setBitsName(((YangLeafList)tmpData).getName());
                    break;
                }
                case TYPEDEF_DATA: {
                    bitsNode.setBitsName(((YangTypeDef)tmpData).getName());
                    break;
                }
                case UNION_DATA: {
                    bitsNode.setBitsName(((YangUnion)tmpData).getName());
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ((YangType)typeData).getDataTypeName(), ListenerErrorLocation.ENTRY));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.BITS_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(typeData);
        listener.getParsedDataStack().push(bitsNode);
    }

    public static void processBitsExit(TreeWalkListener listener, GeneratedYangParser.BitsSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BITS_DATA, "", ListenerErrorLocation.EXIT);
        Parsable tmpBitsNode = listener.getParsedDataStack().peek();
        if (tmpBitsNode instanceof YangBits) {
            YangBits bitsNode = (YangBits)tmpBitsNode;
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BITS_DATA, "", ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case TYPE_DATA: {
                    YangType typeNode = (YangType)tmpNode;
                    typeNode.setDataTypeExtendedInfo(bitsNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.BITS_DATA, "", ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.BITS_DATA, "", ListenerErrorLocation.EXIT));
        }
    }
}

