/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import java.util.List;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class CompilerAnnotationListener {
    private CompilerAnnotationListener() {
    }

    public static void processCompilerAnnotationEntry(TreeWalkListener listener, GeneratedYangParser.CompilerAnnotationStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.COMPILER_ANNOTATION_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        String prefix = ListenerUtil.getValidPrefix(ctx.COMPILER_ANNOTATION().getText(), YangConstructType.COMPILER_ANNOTATION_DATA, ctx);
        YangCompilerAnnotation compilerAnnotation = new YangCompilerAnnotation();
        compilerAnnotation.setPrefix(prefix);
        compilerAnnotation.setPath(ListenerUtil.removeQuotesAndHandleConcat(ctx.string().getText()));
        compilerAnnotation.setLineNumber(ctx.getStart().getLine());
        compilerAnnotation.setCharPosition(ctx.getStart().getCharPositionInLine());
        compilerAnnotation.setFileName(listener.getFileName());
        List<YangAtomicPath> targetNodes = ListenerUtil.getValidAbsoluteSchemaNodeId(ctx.string().getText(), YangConstructType.COMPILER_ANNOTATION_DATA, ctx);
        compilerAnnotation.setAtomicPathList(targetNodes);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        Parsable curData = listener.getParsedDataStack().peek();
        if (!(curData instanceof YangModule) && !(curData instanceof YangSubModule)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.COMPILER_ANNOTATION_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangResolutionInfoImpl<YangCompilerAnnotation> resolutionInfo = new YangResolutionInfoImpl<YangCompilerAnnotation>(compilerAnnotation, (YangNode)((Object)curData), line, charPositionInLine);
        CompilerAnnotationListener.addToResolutionList(resolutionInfo, ctx);
        listener.getParsedDataStack().push(compilerAnnotation);
    }

    public static void processCompilerAnnotationExit(TreeWalkListener listener, GeneratedYangParser.CompilerAnnotationStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.COMPILER_ANNOTATION_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangCompilerAnnotation)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.COMPILER_ANNOTATION_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void addToResolutionList(YangResolutionInfoImpl<YangCompilerAnnotation> resolutionInfo, GeneratedYangParser.CompilerAnnotationStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.COMPILER_ANNOTATION_DATA, ctx.COMPILER_ANNOTATION().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }
}

