/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangContainer;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class ConfigListener {
    private ConfigListener() {
    }

    public static void processConfigEntry(TreeWalkListener listener, GeneratedYangParser.ConfigStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.CONFIG_DATA, "", ListenerErrorLocation.ENTRY);
        boolean isConfig = ListenerUtil.getValidBooleanValue(ctx.config().getText(), YangConstructType.CONFIG_DATA, ctx);
        Parsable tmpData = listener.getParsedDataStack().peek();
        switch (tmpData.getYangConstructType()) {
            case LEAF_DATA: {
                YangLeaf leaf = (YangLeaf)tmpData;
                leaf.setConfig(isConfig);
                break;
            }
            case CONTAINER_DATA: {
                YangContainer container = (YangContainer)tmpData;
                container.setConfig(isConfig);
                break;
            }
            case LEAF_LIST_DATA: {
                YangLeafList leafList = (YangLeafList)tmpData;
                leafList.setConfig(isConfig);
                break;
            }
            case LIST_DATA: {
                YangList yangList = (YangList)tmpData;
                yangList.setConfig(isConfig);
                break;
            }
            case CHOICE_DATA: {
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.CONFIG_DATA, "", ListenerErrorLocation.ENTRY));
            }
        }
    }
}

