/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangAppErrorHolder;
import org.onosproject.yangutils.datamodel.YangAppErrorInfo;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class ErrorMessageListener {
    private ErrorMessageListener() {
    }

    public static void processErrorMessageEntry(TreeWalkListener listener, GeneratedYangParser.ErrorMessageStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ERROR_MESSAGE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        String errorMessage = ListenerUtil.removeQuotesAndHandleConcat(ctx.string().getText());
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangAppErrorHolder)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ERROR_MESSAGE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangAppErrorInfo yangAppErrorInfo = ((YangAppErrorHolder)((Object)tmpNode)).getAppErrorInfo();
        yangAppErrorInfo.setErrorMessage(errorMessage);
        yangAppErrorInfo.setLineNumber(ctx.getStart().getLine());
        yangAppErrorInfo.setCharPosition(ctx.getStart().getCharPositionInLine());
        yangAppErrorInfo.setFileName(listener.getFileName());
    }
}

