/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class LeafListener {
    private LeafListener() {
    }

    public static void processLeafEntry(TreeWalkListener listener, GeneratedYangParser.LeafStatementContext ctx) {
        Parsable tmpData;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LEAF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.LEAF_DATA, ctx);
        LeafListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.LEAF_DATA);
        YangLeaf leaf = YangDataModelFactory.getYangLeaf(GeneratedLanguage.JAVA_GENERATION);
        leaf.setName(identifier);
        leaf.setLineNumber(line);
        leaf.setCharPosition(charPositionInLine);
        leaf.setFileName(listener.getFileName());
        if (ctx.configStatement().isEmpty()) {
            boolean parentConfig = ListenerValidation.getParentNodeConfig(listener);
            leaf.setConfig(parentConfig);
        }
        if ((tmpData = listener.getParsedDataStack().peek()) instanceof YangLeavesHolder) {
            YangList list;
            YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)tmpData);
            leavesHolder.addLeaf(leaf);
            leaf.setContainedIn(leavesHolder);
            if (tmpData instanceof YangList && (list = (YangList)tmpData).isConfig()) {
                for (String key : list.getKeyList()) {
                    if (!key.equals(leaf.getName())) continue;
                    leaf.setKeyLeaf(true);
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LEAF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(leaf);
    }

    public static void processLeafExit(TreeWalkListener listener, GeneratedYangParser.LeafStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LEAF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (listener.getParsedDataStack().peek() instanceof YangLeaf) {
            YangLeaf leafNode = (YangLeaf)listener.getParsedDataStack().peek();
            try {
                leafNode.validateDataOnExit();
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_CONTENT, YangConstructType.LEAF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.LEAF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.LeafStatementContext ctx) {
        ListenerValidation.validateCardinalityEqualsOne(ctx.typeStatement(), YangConstructType.TYPE_DATA, YangConstructType.LEAF_DATA, ctx.identifier().getText(), ctx);
        ListenerValidation.validateCardinalityMaxOne(ctx.unitsStatement(), YangConstructType.UNITS_DATA, YangConstructType.LEAF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.configStatement(), YangConstructType.CONFIG_DATA, YangConstructType.LEAF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.mandatoryStatement(), YangConstructType.MANDATORY_DATA, YangConstructType.LEAF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.LEAF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.LEAF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.LEAF_DATA, ctx.identifier().getText());
    }
}

