/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangMaxElement;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class MaxElementsListener {
    private static final String POSITIVE_INTEGER_PATTERN = "[1-9][0-9]*";
    private static final String UNBOUNDED_KEYWORD = "unbounded";

    private MaxElementsListener() {
    }

    public static void processMaxElementsEntry(TreeWalkListener listener, GeneratedYangParser.MaxElementsStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MAX_ELEMENT_DATA, "", ListenerErrorLocation.ENTRY);
        int maxElementsValue = MaxElementsListener.getValidMaxElementValue(ctx);
        YangMaxElement maxElement = new YangMaxElement();
        maxElement.setMaxElement(maxElementsValue);
        maxElement.setLineNumber(ctx.getStart().getLine());
        maxElement.setCharPosition(ctx.getStart().getCharPositionInLine());
        maxElement.setFileName(listener.getFileName());
        Parsable tmpData = listener.getParsedDataStack().peek();
        switch (tmpData.getYangConstructType()) {
            case LEAF_LIST_DATA: {
                YangLeafList leafList = (YangLeafList)tmpData;
                leafList.setMaxElements(maxElement);
                break;
            }
            case LIST_DATA: {
                YangList yangList = (YangList)tmpData;
                yangList.setMaxElements(maxElement);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.MAX_ELEMENT_DATA, "", ListenerErrorLocation.ENTRY));
            }
        }
    }

    private static int getValidMaxElementValue(GeneratedYangParser.MaxElementsStatementContext ctx) {
        int maxElementsValue;
        String value = ListenerUtil.removeQuotesAndHandleConcat(ctx.maxValue().getText());
        if (value.equals(UNBOUNDED_KEYWORD)) {
            maxElementsValue = Integer.MAX_VALUE;
        } else if (value.matches(POSITIVE_INTEGER_PATTERN)) {
            try {
                maxElementsValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.MAX_ELEMENT_DATA) + " value " + value + " is not " + "valid.");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
        } else {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.MAX_ELEMENT_DATA) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return maxElementsValue;
    }
}

