/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.YangUnion;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class TypeListener {
    private TypeListener() {
    }

    public static void processTypeEntry(TreeWalkListener listener, GeneratedYangParser.TypeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.TYPE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        YangNodeIdentifier nodeIdentifier = ListenerUtil.getValidNodeIdentifier(ctx.string().getText(), YangConstructType.TYPE_DATA, ctx);
        YangDataTypes yangDataTypes = YangDataTypes.getType(ctx.string().getText());
        TypeListener.validateTypeSubStatementCardinality(ctx, yangDataTypes);
        YangType type = YangDataModelFactory.getYangType(GeneratedLanguage.JAVA_GENERATION);
        type.setNodeId(nodeIdentifier);
        type.setDataType(yangDataTypes);
        type.setLineNumber(ctx.getStart().getLine());
        type.setCharPosition(ctx.getStart().getCharPositionInLine());
        type.setFileName(listener.getFileName());
        TypeListener.setDefaultRequireInstanceForInstanceIdentifier(type);
        int errorLine = ctx.getStart().getLine();
        int errorPosition = ctx.getStart().getCharPositionInLine();
        Parsable tmpData = listener.getParsedDataStack().peek();
        switch (tmpData.getYangConstructType()) {
            case LEAF_DATA: {
                YangLeaf leaf = (YangLeaf)tmpData;
                leaf.setDataType(type);
                if (yangDataTypes != YangDataTypes.DERIVED) break;
                Parsable leafData = listener.getParsedDataStack().pop();
                Parsable parentNodeOfLeaf = listener.getParsedDataStack().peek();
                listener.getParsedDataStack().push(leafData);
                if (!(parentNodeOfLeaf instanceof YangNode)) {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
                }
                YangDerivedInfo yangDerivedInfo = new YangDerivedInfo();
                yangDerivedInfo.setLineNumber(ctx.getStart().getLine());
                yangDerivedInfo.setCharPosition(ctx.getStart().getCharPositionInLine());
                yangDerivedInfo.setFileName(listener.getFileName());
                type.setDataTypeExtendedInfo(yangDerivedInfo);
                type.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                YangResolutionInfoImpl<YangType> resolutionInfo = new YangResolutionInfoImpl<YangType>(type, (YangNode)((Object)parentNodeOfLeaf), errorLine, errorPosition);
                TypeListener.addToResolutionList(resolutionInfo, ctx);
                break;
            }
            case LEAF_LIST_DATA: {
                YangLeafList leafList = (YangLeafList)tmpData;
                leafList.setDataType(type);
                if (yangDataTypes != YangDataTypes.DERIVED) break;
                Parsable leafListData = listener.getParsedDataStack().pop();
                Parsable parentNodeOfLeafList = listener.getParsedDataStack().peek();
                listener.getParsedDataStack().push(leafListData);
                if (!(parentNodeOfLeafList instanceof YangNode)) {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
                }
                YangDerivedInfo yangDerivedInfo = new YangDerivedInfo();
                yangDerivedInfo.setLineNumber(ctx.getStart().getLine());
                yangDerivedInfo.setCharPosition(ctx.getStart().getCharPositionInLine());
                yangDerivedInfo.setFileName(listener.getFileName());
                type.setDataTypeExtendedInfo(yangDerivedInfo);
                YangResolutionInfoImpl<YangType> resolutionInfo = new YangResolutionInfoImpl<YangType>(type, (YangNode)((Object)parentNodeOfLeafList), errorLine, errorPosition);
                TypeListener.addToResolutionList(resolutionInfo, ctx);
                break;
            }
            case UNION_DATA: {
                YangUnion unionNode = (YangUnion)tmpData;
                try {
                    unionNode.addType(type);
                }
                catch (DataModelException e) {
                    ParserException parserException = new ParserException(e.getMessage());
                    parserException.setLine(ctx.getStart().getLine());
                    parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                    throw parserException;
                }
                if (yangDataTypes != YangDataTypes.DERIVED) break;
                YangDerivedInfo yangDerivedInfo = new YangDerivedInfo();
                yangDerivedInfo.setLineNumber(ctx.getStart().getLine());
                yangDerivedInfo.setCharPosition(ctx.getStart().getCharPositionInLine());
                yangDerivedInfo.setFileName(listener.getFileName());
                type.setDataTypeExtendedInfo(yangDerivedInfo);
                type.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                YangResolutionInfoImpl<YangType> resolutionInfo = new YangResolutionInfoImpl<YangType>(type, unionNode, errorLine, errorPosition);
                TypeListener.addToResolutionList(resolutionInfo, ctx);
                break;
            }
            case TYPEDEF_DATA: {
                YangTypeDef typeDef = (YangTypeDef)tmpData;
                typeDef.setDataType(type);
                if (yangDataTypes != YangDataTypes.DERIVED) break;
                YangDerivedInfo yangDerivedInfo = new YangDerivedInfo();
                yangDerivedInfo.setLineNumber(ctx.getStart().getLine());
                yangDerivedInfo.setCharPosition(ctx.getStart().getCharPositionInLine());
                yangDerivedInfo.setFileName(listener.getFileName());
                type.setDataTypeExtendedInfo(yangDerivedInfo);
                type.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                YangResolutionInfoImpl<YangType> resolutionInfo = new YangResolutionInfoImpl<YangType>(type, typeDef, errorLine, errorPosition);
                TypeListener.addToResolutionList(resolutionInfo, ctx);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
            }
        }
        listener.getParsedDataStack().push(type);
    }

    private static void setDefaultRequireInstanceForInstanceIdentifier(YangType<?> type) {
        if (type.getDataType() == YangDataTypes.INSTANCE_IDENTIFIER) {
            type.setDataTypeExtendedInfo(true);
        }
    }

    public static void processTypeExit(TreeWalkListener listener, GeneratedYangParser.TypeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.TYPE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        Parsable parsableType = listener.getParsedDataStack().pop();
        if (!(parsableType instanceof YangType)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
    }

    private static void addToResolutionList(YangResolutionInfoImpl<YangType> resolutionInfo, GeneratedYangParser.TypeStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.TYPE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }

    private static void validateTypeSubStatementCardinality(GeneratedYangParser.TypeStatementContext ctx, YangDataTypes yangDataType) {
        if (ctx.typeBodyStatements() == null || ctx.typeBodyStatements().isEmpty()) {
            ParserException parserException;
            switch (yangDataType) {
                case UNION: {
                    parserException = new ParserException("YANG file error : a type union must have atleast one type statement.");
                    break;
                }
                case ENUMERATION: {
                    parserException = new ParserException("YANG file error : a type enumeration must have atleast one enum statement.");
                    break;
                }
                case BITS: {
                    parserException = new ParserException("YANG file error : a type bits must have atleast one bit statement.");
                    break;
                }
                case DECIMAL64: {
                    parserException = new ParserException("YANG file error : a type decimal64 must have fraction-digits statement.");
                    break;
                }
                case LEAFREF: {
                    parserException = new ParserException("YANG file error : a type leafref must have one path statement.");
                    break;
                }
                case IDENTITYREF: {
                    parserException = new ParserException("YANG file error : a type identityref must have base statement.");
                    break;
                }
                default: {
                    return;
                }
            }
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
    }
}

