/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.plugin.buck;

import com.facebook.buck.io.ProjectFilesystem;
import com.facebook.buck.step.AbstractExecutionStep;
import com.facebook.buck.step.ExecutionContext;
import com.facebook.buck.step.StepExecutionResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.onosproject.yangutils.plugin.buck.YangGenerator;
import org.onosproject.yangutils.plugin.buck.YangParsingException;

public class YangStep
extends AbstractExecutionStep {
    private static final String DESCRIPTION = "yang-compile";
    private final ProjectFilesystem filesystem;
    private final List<Path> srcs;
    private final Path output;

    YangStep(ProjectFilesystem filesystem, List<Path> srcs, Path genSourcesDirectory) {
        super(DESCRIPTION);
        this.filesystem = filesystem;
        this.srcs = srcs;
        this.output = genSourcesDirectory;
    }

    public StepExecutionResult execute(ExecutionContext executionContext) throws IOException, InterruptedException {
        List<File> sourceFiles = this.srcs.stream().map(Path::toFile).collect(Collectors.toList());
        try {
            new YangGenerator(sourceFiles, this.output.toString()).execute();
            return StepExecutionResult.SUCCESS;
        }
        catch (YangParsingException e) {
            executionContext.getConsole().printErrorText(e.getMessage());
            return StepExecutionResult.ERROR;
        }
    }
}

