/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.javadatamodel.JavaQualifiedTypeInfo;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.javamodel.AttributesJavaDataType;
import org.onosproject.yangutils.translator.tojava.javamodel.JavaLeafInfoContainer;
import org.onosproject.yangutils.utils.io.YangToJavaNamingConflictUtil;

public class JavaQualifiedTypeInfoTranslator
extends JavaQualifiedTypeInfo
implements Comparable<JavaQualifiedTypeInfoTranslator>,
Serializable {
    private static final long serialVersionUID = 806201634L;
    private boolean isQualified;
    private boolean isForInterface = true;

    @Override
    public String getPkgInfo() {
        return this.pkgInfo;
    }

    @Override
    public void setPkgInfo(String pkgInfo) {
        this.pkgInfo = pkgInfo;
    }

    @Override
    public String getClassInfo() {
        return this.classInfo;
    }

    @Override
    public void setClassInfo(String classInfo) {
        this.classInfo = classInfo;
    }

    public static void updateLeavesJavaQualifiedInfo(JavaLeafInfoContainer leaf) {
        JavaQualifiedTypeInfoTranslator importInfo = (JavaQualifiedTypeInfoTranslator)leaf.getJavaQualifiedInfo();
        if (leaf.getDataType() == null) {
            throw new TranslatorException("missing data type of leaf " + leaf.getName() + " in " + leaf.getLineNumber() + " at" + leaf.getCharPosition() + " in " + leaf.getFileName());
        }
        String className = AttributesJavaDataType.getJavaImportClass(leaf.getDataType(), leaf.isLeafList(), leaf.getConflictResolveConfig());
        if (className != null) {
            importInfo.setClassInfo(className);
            String classPkg = AttributesJavaDataType.getJavaImportPackage(leaf.getDataType(), leaf.isLeafList(), leaf.getConflictResolveConfig());
            if (classPkg == null) {
                throw new TranslatorException("import package cannot be null when the class is used for " + leaf.getName() + " in " + leaf.getLineNumber() + " at" + leaf.getCharPosition() + " in " + leaf.getFileName());
            }
            importInfo.setPkgInfo(classPkg);
        } else {
            String dataTypeName = AttributesJavaDataType.getJavaDataType(leaf.getDataType());
            if (dataTypeName == null) {
                throw new TranslatorException("not supported data type for " + leaf.getName() + " in " + leaf.getLineNumber() + " at" + leaf.getCharPosition() + " in " + leaf.getFileName());
            }
            importInfo.setClassInfo(dataTypeName);
        }
        leaf.getJavaQualifiedInfo().setJavaAttributeName(leaf.getJavaName(leaf.getConflictResolveConfig()));
    }

    public static JavaQualifiedTypeInfoTranslator getQualifiedTypeInfoOfCurNode(YangNode curNode, String attributeName) {
        JavaQualifiedTypeInfoTranslator importInfo = new JavaQualifiedTypeInfoTranslator();
        if (!(curNode instanceof JavaFileInfoContainer)) {
            throw new TranslatorException("missing java file information to get the package details of attribute corresponding to child node " + curNode.getName() + " in " + curNode.getLineNumber() + " at " + curNode.getCharPosition() + " in " + curNode.getFileName());
        }
        importInfo.setClassInfo(attributeName);
        importInfo.setPkgInfo(((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getPackage());
        return importInfo;
    }

    static JavaQualifiedTypeInfoTranslator getQualifiedInfoOfFromString(JavaAttributeInfo referredTypesAttrInfo, YangToJavaNamingConflictUtil conflictResolver) {
        JavaQualifiedTypeInfoTranslator qualifiedInfoOfFromString = new JavaQualifiedTypeInfoTranslator();
        if (referredTypesAttrInfo.getAttributeType().getDataType() == YangDataTypes.BINARY) {
            qualifiedInfoOfFromString.setClassInfo("Base64");
            qualifiedInfoOfFromString.setPkgInfo("java.util");
        } else {
            qualifiedInfoOfFromString.setClassInfo(AttributesJavaDataType.getJavaImportClass(referredTypesAttrInfo.getAttributeType(), true, conflictResolver));
            qualifiedInfoOfFromString.setPkgInfo(AttributesJavaDataType.getJavaImportPackage(referredTypesAttrInfo.getAttributeType(), true, conflictResolver));
        }
        return qualifiedInfoOfFromString;
    }

    public int hashCode() {
        return Objects.hash(this.pkgInfo, this.classInfo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JavaQualifiedTypeInfoTranslator) {
            JavaQualifiedTypeInfoTranslator other = (JavaQualifiedTypeInfoTranslator)obj;
            return Objects.equals(this.pkgInfo, other.pkgInfo) && Objects.equals(this.classInfo, other.classInfo);
        }
        return false;
    }

    public boolean exactMatch(JavaQualifiedTypeInfoTranslator importInfo) {
        return this.equals(importInfo) && Objects.equals(this.pkgInfo, importInfo.getPkgInfo()) && Objects.equals(this.classInfo, importInfo.getClassInfo());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("pkgInfo", (Object)this.pkgInfo).add("classInfo", (Object)this.classInfo).toString();
    }

    @Override
    public int compareTo(JavaQualifiedTypeInfoTranslator other) {
        return this.getClassInfo().compareTo(other.getClassInfo());
    }

    public boolean isQualified() {
        return this.isQualified;
    }

    public void setQualified(boolean qualified) {
        this.isQualified = qualified;
    }

    boolean isForInterface() {
        return this.isForInterface;
    }

    void setForInterface(boolean forInterface) {
        this.isForInterface = forInterface;
    }
}

