/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangDataStructure;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.javadatamodel.JavaQualifiedTypeInfo;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.javamodel.AttributesJavaDataType;
import org.onosproject.yangutils.translator.tojava.javamodel.JavaLeafInfoContainer;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaGroupingTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaLeafTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.StringGenerator;
import org.onosproject.yangutils.translator.tojava.utils.SubtreeFilteringMethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorErrorType;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaFragmentFiles {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String TEMP_FOLDER_NAME_SUFFIX = "-Temp";
    private static final String GETTER_METHOD_FILE_NAME = "GetterMethod";
    private static final String SETTER_METHOD_FILE_NAME = "SetterMethod";
    private static final String GETTER_METHOD_IMPL_FILE_NAME = "GetterMethodImpl";
    private static final String SETTER_METHOD_IMPL_FILE_NAME = "SetterMethodImpl";
    private static final String ATTRIBUTE_FILE_NAME = "Attributes";
    private static final String TO_STRING_METHOD_FILE_NAME = "ToString";
    private static final String HASH_CODE_METHOD_FILE_NAME = "HashCode";
    private static final String EQUALS_METHOD_FILE_NAME = "Equals";
    private static final String FROM_STRING_METHOD_FILE_NAME = "FromString";
    private static final String ADD_TO_LIST_INTERFACE_METHOD_FILE_NAME = "addToList";
    private static final String ADD_TO_LIST_IMPL_METHOD_FILE_NAME = "addToListImpl";
    private static final String LEAF_IDENTIFIER_ATTRIBUTES_FILE_NAME = "leafIdentifierAtr";
    private static final String FILTER_CONTENT_MATCH_LEAF_FILE_NAME = "isFilterContentMatchLeafMask";
    private static final String FILTER_CONTENT_MATCH_LEAF_LIST_FILE_NAME = "isFilterContentMatchLeafListMask";
    private static final String FILTER_CONTENT_MATCH_NODE_FILE_NAME = "isFilterContentMatchNodeMask";
    private static final String EDIT_CONTENT_FILE_NAME = "editContentFile";
    private static final String INTERFACE_FILE_NAME_SUFFIX = "";
    private static final String BUILDER_INTERFACE_FILE_NAME_SUFFIX = "Builderinterface";
    private static final String BUILDER_CLASS_FILE_NAME_SUFFIX = "Builder";
    private static final String KEY_CLASS_FILE_NAME_SUFFIX = "Keys";
    private YangNode attrNode;
    private JavaFileInfoTranslator javaFileInfo;
    private JavaImportData javaImportData;
    private int tempFilesFlagSet;
    private String absoluteDirPath;
    private JavaExtendsListHolder javaExtendsListHolder;
    private File interfaceJavaFileHandle;
    private File builderInterfaceJavaFileHandle;
    private File builderClassJavaFileHandle;
    private File implClassJavaFileHandle;
    private File attributesTempFileHandle;
    private File getterInterfaceTempFileHandle;
    private File setterInterfaceTempFileHandle;
    private File getterImplTempFileHandle;
    private File setterImplTempFileHandle;
    private File hashCodeImplTempFileHandle;
    private File equalsImplTempFileHandle;
    private File toStringImplTempFileHandle;
    private File fromStringImplTempFileHandle;
    private File addToListInterfaceTempFileHandle;
    private File addToListImplTempFileHandle;
    private File leafIdAttributeTempFileHandle;
    private File getSubtreeFilteringForListTempFileHandle;
    private File getSubtreeFilteringForChildNodeTempFileHandle;
    private File subtreeFilteringForLeafTempFileHandle;
    private File editContentTempFileHandle;
    private int leafCount;
    private boolean rootNode;
    private boolean isAttributePresent;

    TempJavaFragmentFiles() {
    }

    protected TempJavaFragmentFiles(JavaFileInfoTranslator fileInfo) throws IOException {
        this.javaExtendsListHolder = new JavaExtendsListHolder();
        this.javaImportData = new JavaImportData();
        this.javaFileInfo = fileInfo;
        this.absoluteDirPath = YangIoUtils.getAbsolutePackagePath(fileInfo.getBaseCodeGenPath(), fileInfo.getPackageFilePath());
        if (this.javaFlagSet(1)) {
            this.addGeneratedTempFile(0x500002);
        }
        if (this.javaFlagSet(2)) {
            this.addGeneratedTempFile(10);
        }
        if (this.javaFlagSet(4)) {
            this.addGeneratedTempFile(21);
        }
        if (this.javaFlagSet(8)) {
            this.addGeneratedTempFile(60817861);
        }
        if (this.javaFlagSet(192)) {
            this.addGeneratedTempFile(2245);
            if (this.getGeneratedJavaFiles() != 128) {
                this.addGeneratedTempFile(256);
            }
        }
        if (this.tempFlagSet(1)) {
            this.attributesTempFileHandle = this.getTemporaryFileHandle(ATTRIBUTE_FILE_NAME);
        }
        if (this.tempFlagSet(2)) {
            this.getterInterfaceTempFileHandle = this.getTemporaryFileHandle(GETTER_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(8)) {
            this.setterInterfaceTempFileHandle = this.getTemporaryFileHandle(SETTER_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(4)) {
            this.getterImplTempFileHandle = this.getTemporaryFileHandle(GETTER_METHOD_IMPL_FILE_NAME);
        }
        if (this.tempFlagSet(16)) {
            this.setterImplTempFileHandle = this.getTemporaryFileHandle(SETTER_METHOD_IMPL_FILE_NAME);
        }
        if (this.tempFlagSet(64)) {
            this.hashCodeImplTempFileHandle = this.getTemporaryFileHandle(HASH_CODE_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(128)) {
            this.equalsImplTempFileHandle = this.getTemporaryFileHandle(EQUALS_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(256)) {
            this.toStringImplTempFileHandle = this.getTemporaryFileHandle(TO_STRING_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(2048)) {
            this.fromStringImplTempFileHandle = this.getTemporaryFileHandle(FROM_STRING_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(0x100000)) {
            this.addToListInterfaceTempFileHandle = this.getTemporaryFileHandle(ADD_TO_LIST_INTERFACE_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(0x200000)) {
            this.addToListImplTempFileHandle = this.getTemporaryFileHandle(ADD_TO_LIST_IMPL_METHOD_FILE_NAME);
        }
        if (this.tempFlagSet(0x400000)) {
            this.leafIdAttributeTempFileHandle = this.getTemporaryFileHandle(LEAF_IDENTIFIER_ATTRIBUTES_FILE_NAME);
        }
        if (this.tempFlagSet(0x800000)) {
            this.subtreeFilteringForLeafTempFileHandle = this.getTemporaryFileHandle(FILTER_CONTENT_MATCH_LEAF_FILE_NAME);
        }
        if (this.tempFlagSet(0x1000000)) {
            this.getSubtreeFilteringForListTempFileHandle = this.getTemporaryFileHandle(FILTER_CONTENT_MATCH_LEAF_LIST_FILE_NAME);
        }
        if (this.tempFlagSet(0x2000000)) {
            this.getSubtreeFilteringForChildNodeTempFileHandle = this.getTemporaryFileHandle(FILTER_CONTENT_MATCH_NODE_FILE_NAME);
        }
        if (this.tempFlagSet(0x4000000)) {
            this.editContentTempFileHandle = this.getTemporaryFileHandle(EDIT_CONTENT_FILE_NAME);
        }
    }

    protected static void addCurNodeInfoInParentTempFile(YangNode curNode, boolean isList, YangPluginConfig config) throws IOException {
        YangNode parent = DataModelUtils.getParentNodeInGenCode(curNode);
        if (!(parent instanceof JavaCodeGenerator)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.MISSING_PARENT_NODE, curNode));
        }
        if (parent instanceof YangJavaGroupingTranslator) {
            return;
        }
        TempJavaFragmentFiles.addCurNodeInfoInParentTempFile(curNode, isList, config, parent);
    }

    protected static void addCurNodeInfoInParentTempFile(YangNode curNode, boolean isList, YangPluginConfig config, YangNode parent) throws IOException {
        TempJavaBeanFragmentFiles tempFiles = TranslatorUtils.getBeanFiles((JavaCodeGeneratorInfo)((Object)parent));
        tempFiles.setAttrNode(curNode);
        JavaFileInfoTranslator fileInfo = ((JavaCodeGeneratorInfo)((Object)parent)).getJavaFileInfo();
        if (curNode instanceof YangChoice && curNode.isOpTypeReq()) {
            JavaQualifiedTypeInfoTranslator info = new JavaQualifiedTypeInfoTranslator();
            info.setClassInfo("InvocationTargetException");
            info.setPkgInfo("java.lang.reflect");
            info.setForInterface(false);
            tempFiles.getJavaImportData().addImportInfo(info, YangIoUtils.getCapitalCase(fileInfo.getJavaName()), fileInfo.getPackage());
        }
        JavaAttributeInfo attr = TempJavaFragmentFiles.getCurNodeAsAttributeInTarget(curNode, parent, isList, tempFiles);
        tempFiles.addJavaSnippetInfoToApplicableTempFiles(attr, config);
    }

    public static JavaAttributeInfo getCurNodeAsAttributeInTarget(YangNode curNode, YangNode targetNode, boolean listNode, TempJavaFragmentFiles tempFiles) {
        YangList yangList;
        YangDataStructure ds;
        boolean qualified;
        JavaFileInfoTranslator translator = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String curNodeName = translator.getJavaName();
        if (curNodeName == null) {
            AttributesJavaDataType.updateJavaFileInfo(curNode, null);
            curNodeName = translator.getJavaName();
        }
        JavaQualifiedTypeInfoTranslator typeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(curNode, YangIoUtils.getCapitalCase(curNodeName));
        if (!(targetNode instanceof TempJavaCodeFragmentFilesContainer)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_PARENT_NODE, curNode));
        }
        JavaImportData parentImportData = tempFiles.getJavaImportData();
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)targetNode)).getJavaFileInfo();
        if (tempFiles instanceof TempJavaServiceFragmentFiles && typeInfo.getClassInfo().contentEquals("Service") || typeInfo.getClassInfo().contentEquals(YangIoUtils.getCapitalCase(fileInfo.getJavaName() + "Service"))) {
            qualified = true;
        } else {
            String className = tempFiles instanceof TempJavaServiceFragmentFiles ? YangIoUtils.getCapitalCase(fileInfo.getJavaName()) + "Service" : YangIoUtils.getCapitalCase(fileInfo.getJavaName());
            qualified = parentImportData.addImportInfo(typeInfo, className, fileInfo.getPackage());
            if (!qualified && !(curNode instanceof YangChoice) && targetNode.isOpTypeReq()) {
                String name = "Default" + typeInfo.getClassInfo();
                JavaQualifiedTypeInfoTranslator qInfo = new JavaQualifiedTypeInfoTranslator();
                qInfo.setForInterface(false);
                qInfo.setPkgInfo(typeInfo.getPkgInfo());
                qInfo.setClassInfo(name);
                parentImportData.addImportInfo(qInfo, className, fileInfo.getPackage());
            }
        }
        boolean collectionSet = false;
        if (curNode instanceof YangList && (ds = MethodsGenerator.getYangDataStructure((yangList = (YangList)curNode).getCompilerAnnotation())) != null) {
            switch (ds) {
                case QUEUE: {
                    parentImportData.setQueueToImport(true);
                    collectionSet = true;
                    break;
                }
                case SET: {
                    parentImportData.setSetToImport(true);
                    collectionSet = true;
                    break;
                }
                case MAP: {
                    parentImportData.setMapToImport(true);
                    collectionSet = true;
                    break;
                }
                default: {
                    parentImportData.setIfListImported(true);
                    collectionSet = true;
                }
            }
        }
        if (listNode && !collectionSet) {
            parentImportData.setIfListImported(true);
        }
        if (curNode instanceof YangList) {
            return JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, curNodeName, null, qualified, listNode, ((YangList)curNode).getCompilerAnnotation());
        }
        return JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, curNodeName, null, qualified, listNode);
    }

    private static JavaAttributeInfo getJavaAttributeOfLeaf(TempJavaFragmentFiles tempFiles, JavaLeafInfoContainer container, YangPluginConfig config, boolean leafList) throws IOException {
        if (leafList) {
            tempFiles.getJavaImportData().setIfListImported(true);
            return TempJavaFragmentFiles.getAttributeOfLeafInfoContainer(tempFiles, container, config, true);
        }
        return TempJavaFragmentFiles.getAttributeOfLeafInfoContainer(tempFiles, container, config, false);
    }

    private static JavaAttributeInfo getAttributeOfLeafInfoContainer(TempJavaFragmentFiles tempFiles, JavaLeafInfoContainer container, YangPluginConfig config, boolean listAttribute) throws IOException {
        boolean condition;
        container.setConflictResolveConfig(config.getConflictResolver());
        container.updateJavaQualifiedInfo();
        TempJavaFragmentFiles.addImportForLeafInfo(tempFiles, container);
        JavaAttributeInfo attr = JavaAttributeInfo.getAttributeInfoForTheData(container.getJavaQualifiedInfo(), container.getJavaName(config.getConflictResolver()), container.getDataType(), tempFiles.getIsQualifiedAccessOrAddToImportList(container.getJavaQualifiedInfo()), listAttribute);
        boolean bl = condition = ((YangSchemaNode)((Object)container)).getReferredSchema() == null && container.getDataType().getDataType() == YangDataTypes.BITS;
        if (condition) {
            TempJavaFragmentFiles.addBitsHandler(attr, container.getDataType(), tempFiles);
        }
        return attr;
    }

    public static List<JavaAttributeInfo> getListOfAttributesForKey(YangNode curNode) throws IOException {
        List<String> keys = ((YangList)curNode).getKeyList();
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        YangLeavesHolder holder = (YangLeavesHolder)((Object)curNode);
        Iterator<String> keyIt = keys.iterator();
        TempJavaBeanFragmentFiles beanFile = TranslatorUtils.getBeanFiles(curNode);
        ArrayList<JavaAttributeInfo> attrs = new ArrayList<JavaAttributeInfo>();
        while (keyIt.hasNext()) {
            String key = keyIt.next();
            for (YangJavaLeafTranslator yangJavaLeafTranslator : holder.getListOfLeaf()) {
                if (!key.equals(yangJavaLeafTranslator.getName())) continue;
                attrs.add(TempJavaFragmentFiles.getAttributeOfLeafInfoContainer(beanFile, yangJavaLeafTranslator, fileInfo.getPluginConfig(), false));
            }
        }
        return attrs;
    }

    static void addBitsHandler(JavaAttributeInfo attr, YangType type, TempJavaFragmentFiles tempFiles) throws IOException {
        YangJavaModelUtils.generateBitsFile(attr, type, tempFiles.getJavaFileInfo(), tempFiles);
    }

    private static void addImportForLeafInfo(TempJavaFragmentFiles tempFiles, JavaLeafInfoContainer container) {
        String containedInCls = YangIoUtils.getCapitalCase(tempFiles.getJavaFileInfo().getJavaName());
        String containedInPkg = tempFiles.getJavaFileInfo().getPackage();
        if (container.getDataType().getDataType() == YangDataTypes.BITS) {
            JavaQualifiedTypeInfoTranslator info = new JavaQualifiedTypeInfoTranslator();
            info.setClassInfo("BitSet");
            info.setPkgInfo("java.util");
            tempFiles.getJavaImportData().addImportInfo(info, containedInCls, containedInPkg);
        }
        tempFiles.getJavaImportData().addImportInfo((JavaQualifiedTypeInfoTranslator)container.getJavaQualifiedInfo(), containedInCls, containedInPkg);
    }

    protected void setAbsoluteDirPath(String absoluteDirPath) {
        this.absoluteDirPath = absoluteDirPath;
    }

    protected JavaFileInfoTranslator getJavaFileInfo() {
        return this.javaFileInfo;
    }

    protected void setJavaFileInfo(JavaFileInfoTranslator javaFileInfo) {
        this.javaFileInfo = javaFileInfo;
    }

    protected int getGeneratedTempFiles() {
        return this.tempFilesFlagSet;
    }

    protected void addGeneratedTempFile(int flags) {
        this.tempFilesFlagSet |= flags;
    }

    protected int getGeneratedJavaFiles() {
        return this.javaFileInfo.getGeneratedFileTypes();
    }

    protected String getGeneratedJavaClassName() {
        return YangIoUtils.getCapitalCase(this.javaFileInfo.getJavaName());
    }

    public JavaImportData getJavaImportData() {
        return this.javaImportData;
    }

    protected void setJavaImportData(JavaImportData data) {
        this.javaImportData = data;
    }

    protected boolean isAttributePresent() {
        return this.isAttributePresent;
    }

    public File getGetterInterfaceTempFileHandle() {
        return this.getterInterfaceTempFileHandle;
    }

    public File getSetterInterfaceTempFileHandle() {
        return this.setterInterfaceTempFileHandle;
    }

    public File getSetterImplTempFileHandle() {
        return this.setterImplTempFileHandle;
    }

    public File getFromStringImplTempFileHandle() {
        return this.fromStringImplTempFileHandle;
    }

    public File getAttributesTempFileHandle() {
        return this.attributesTempFileHandle;
    }

    public File getGetterImplTempFileHandle() {
        return this.getterImplTempFileHandle;
    }

    public File getHashCodeImplTempFileHandle() {
        return this.hashCodeImplTempFileHandle;
    }

    public File getEqualsImplTempFileHandle() {
        return this.equalsImplTempFileHandle;
    }

    public File getToStringImplTempFileHandle() {
        return this.toStringImplTempFileHandle;
    }

    public JavaExtendsListHolder getJavaExtendsListHolder() {
        return this.javaExtendsListHolder;
    }

    protected void setJavaExtendsListHolder(JavaExtendsListHolder holder) {
        this.javaExtendsListHolder = holder;
    }

    private void addSubTreeFilteringForLeaf(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.subtreeFilteringForLeafTempFileHandle, SubtreeFilteringMethodsGenerator.getSubtreeFilteringForLeaf(attr, attr.getAttributeType()) + "\n");
    }

    private void addSubtreeFilteringForLeafList(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getSubtreeFilteringForListTempFileHandle, SubtreeFilteringMethodsGenerator.getSubtreeFilteringForLeafList(attr) + "\n");
    }

    private void addSubtreeFilteringForChildNode(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getSubtreeFilteringForChildNodeTempFileHandle, SubtreeFilteringMethodsGenerator.getSubtreeFilteringForNode(attr, this.attrNode) + "\n");
    }

    private void addAttribute(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.attributesTempFileHandle, this.parseAttribute(attr));
    }

    private void addGetterForInterface(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getterInterfaceTempFileHandle, MethodsGenerator.getGetterString(attr, this.getGeneratedJavaFiles()) + "\n");
    }

    private void addSetterForInterface(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.setterInterfaceTempFileHandle, MethodsGenerator.getSetterString(attr, this.getGeneratedJavaClassName(), this.getGeneratedJavaFiles()) + "\n");
    }

    private void addSetterImpl(JavaAttributeInfo attr) throws IOException {
        String setter = MethodsGenerator.getSetterForClass(attr, this.getGeneratedJavaClassName(), this.getGeneratedJavaFiles());
        String javadoc = StringGenerator.getOverRideString();
        if (attr.getAttributeName().equals("isSubTreeFiltered")) {
            javadoc = JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.SETTER_METHOD, attr.getAttributeName(), false, null);
        }
        this.appendToFile(this.setterImplTempFileHandle, javadoc + setter);
    }

    protected void addGetterImpl(JavaAttributeInfo attr) throws IOException {
        String getter = MethodsGenerator.getGetterForClass(attr, this.getGeneratedJavaFiles());
        String javadoc = StringGenerator.getOverRideString();
        YangDataStructure ds = MethodsGenerator.getYangDataStructure(attr.getCompilerAnnotation());
        String annotation = null;
        if (ds != null) {
            annotation = ds.name();
        }
        if (attr.getAttributeName().equals("isSubTreeFiltered")) {
            javadoc = JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, attr.getAttributeName(), false, annotation);
        }
        if (this.javaFlagSet(4)) {
            this.appendToFile(this.getterImplTempFileHandle, javadoc + getter);
        } else {
            this.appendToFile(this.getterImplTempFileHandle, JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, attr.getAttributeName(), false, annotation) + getter);
        }
    }

    private void addAddToListInterface(JavaAttributeInfo attr) throws IOException {
        YangDataStructure ds = MethodsGenerator.getYangDataStructure(attr.getCompilerAnnotation());
        String annotation = null;
        if (ds != null) {
            annotation = ds.name();
        }
        this.appendToFile(this.addToListInterfaceTempFileHandle, JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.ADD_TO_LIST, attr.getAttributeName(), false, annotation) + MethodsGenerator.getAddToListMethodInterface(attr, this.getGeneratedJavaClassName()) + "\n");
    }

    private void addAddToListImpl(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.addToListImplTempFileHandle, MethodsGenerator.getAddToListMethodImpl(attr, this.getGeneratedJavaClassName()) + "\n");
    }

    private void addLeafIdAttributes(JavaAttributeInfo attr, int value) throws IOException {
        this.appendToFile(this.leafIdAttributeTempFileHandle, "    " + JavaCodeSnippetGen.generateEnumAttributeString(attr.getAttributeName(), value));
    }

    protected String addBuildMethodForInterface() throws IOException {
        return MethodsGenerator.parseBuilderInterfaceBuildMethodString(this.getGeneratedJavaClassName());
    }

    protected String addBuildMethodImpl() throws IOException {
        return MethodsGenerator.getBuildString(this.getGeneratedJavaClassName(), this.rootNode) + "\n";
    }

    protected String addDefaultConstructor(String modifier, String toAppend, boolean suffix) throws IOException {
        StringBuilder name = new StringBuilder();
        name.append(this.getGeneratedJavaClassName());
        if (this.rootNode && !toAppend.equals(BUILDER_CLASS_FILE_NAME_SUFFIX)) {
            name.append("OpParam");
            return MethodsGenerator.getDefaultConstructorString(name.toString(), modifier);
        }
        if (suffix) {
            name.append(toAppend);
            return MethodsGenerator.getDefaultConstructorString(name.toString(), modifier);
        }
        StringBuilder appended = new StringBuilder();
        if (toAppend.equals("default")) {
            appended.append(YangIoUtils.getCapitalCase(toAppend));
        } else {
            appended.append(toAppend);
        }
        return "\n" + MethodsGenerator.getDefaultConstructorString(appended.append((CharSequence)name).toString(), modifier);
    }

    private void addHashCodeMethod(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.hashCodeImplTempFileHandle, MethodsGenerator.getHashCodeMethod(attr) + "\n");
    }

    private void addEqualsMethod(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.equalsImplTempFileHandle, MethodsGenerator.getEqualsMethod(attr) + "\n");
    }

    private void addToStringMethod(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.toStringImplTempFileHandle, MethodsGenerator.getToStringMethod(attr) + "\n");
    }

    void addFromStringMethod(JavaAttributeInfo attr, JavaAttributeInfo fromStringAttr) throws IOException {
        this.appendToFile(this.fromStringImplTempFileHandle, MethodsGenerator.getFromStringMethod(attr, fromStringAttr) + "\n");
    }

    protected File getTemporaryFileHandle(String fileName) throws IOException {
        boolean isCreated;
        String path = this.getTempDirPath(this.absoluteDirPath);
        File dir = new File(path);
        if (!dir.exists() && !(isCreated = dir.mkdirs())) {
            throw new IOException("failed to create temporary directory for " + fileName);
        }
        File file = new File(path + fileName + TEMP_FILE_EXTENSION);
        if (!file.exists()) {
            isCreated = file.createNewFile();
            if (!isCreated) {
                throw new IOException("failed to create temporary file for " + fileName);
            }
        } else {
            throw new IOException(fileName + " is reused due to YANG naming. " + "probably your previous build " + "would have failed");
        }
        return file;
    }

    public File getJavaFileHandle(String fileName) throws IOException {
        return JavaFileGeneratorUtils.getFileObject(this.getDirPath(), fileName, JAVA_FILE_EXTENSION, this.javaFileInfo);
    }

    public String getTemporaryDataFromFileHandle(File file, String absolutePath) throws IOException {
        String path = this.getTempDirPath(absolutePath);
        if (new File(path + file.getName()).exists()) {
            return FileSystemUtil.readAppendFile(path + file.getName(), INTERFACE_FILE_NAME_SUFFIX);
        }
        throw new IOException("Unable to get data from the given " + file.getName() + " file for " + this.getGeneratedJavaClassName() + ".");
    }

    private String getTempDirPath(String path) {
        return YangIoUtils.getPackageDirPathFromJavaJPackage(path) + UtilConstants.SLASH + this.getGeneratedJavaClassName() + TEMP_FOLDER_NAME_SUFFIX + UtilConstants.SLASH;
    }

    protected String parseAttribute(JavaAttributeInfo attr) {
        String attrName = attr.getAttributeName();
        String attrAccessType = "private";
        if ((this.getGeneratedJavaFiles() & 0x200F) != 0) {
            attrAccessType = "protected";
        }
        String pkg = null;
        if (attr.isQualifiedName()) {
            pkg = attr.getImportInfo().getPkgInfo();
        }
        String attrType = attr.getImportInfo().getClassInfo();
        if (attr.getAttributeType() != null && attr.getAttributeType().getDataType() == YangDataTypes.IDENTITYREF) {
            String type = attrType;
            if (pkg != null) {
                type = pkg + "." + attrType;
            }
            attrType = "Class<? extends " + type + ">";
            return JavaCodeSnippetGen.getJavaAttributeDefinition(null, attrType, attrName, attr.isListAttr(), attrAccessType, attr.getCompilerAnnotation());
        }
        return JavaCodeSnippetGen.getJavaAttributeDefinition(pkg, attrType, attrName, attr.isListAttr(), attrAccessType, attr.getCompilerAnnotation());
    }

    protected void appendToFile(File file, String data) throws IOException {
        try {
            YangIoUtils.insertDataIntoJavaFile(file, data);
        }
        catch (IOException ex) {
            throw new IOException("failed to write in temp file.");
        }
    }

    protected void addParentInfoInCurNodeTempFile(YangNode curNode, YangPluginConfig config) {
        JavaQualifiedTypeInfoTranslator caseImportInfo = new JavaQualifiedTypeInfoTranslator();
        YangNode parent = DataModelUtils.getParentNodeInGenCode(curNode);
        if (curNode instanceof YangCase && parent instanceof YangAugment) {
            return;
        }
        if (!(parent instanceof JavaCodeGenerator)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_PARENT_NODE, curNode));
        }
        if (!(curNode instanceof JavaFileInfoContainer)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_NODE, curNode));
        }
        caseImportInfo.setClassInfo(YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(parent.getName(), config.getConflictResolver())));
        caseImportInfo.setPkgInfo(((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo().getPackage());
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        TranslatorUtils.getBeanFiles(curNode).getJavaImportData().addImportInfo(caseImportInfo, YangIoUtils.getCapitalCase(fileInfo.getJavaName()), fileInfo.getPackage());
    }

    private void addLeafInfoToTempFiles(JavaLeafInfoContainer entry, YangPluginConfig config, YangNode curNode, boolean leafList) throws IOException {
        if (entry != null) {
            if (curNode instanceof RpcNotificationContainer) {
                TempJavaBeanFragmentFiles tempFiles = TranslatorUtils.getBeanFiles(curNode);
                this.addJavaSnippetInfoToApplicableTempFiles(TempJavaFragmentFiles.getJavaAttributeOfLeaf(tempFiles, entry, config, leafList), config);
            } else {
                this.addJavaSnippetInfoToApplicableTempFiles(TempJavaFragmentFiles.getJavaAttributeOfLeaf(this, entry, config, leafList), config);
            }
        }
    }

    protected void addCurNodeLeavesInfoToTempFiles(YangNode curNode, YangPluginConfig config) throws IOException {
        if (!(curNode instanceof YangLeavesHolder)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_LEAF_HOLDER, curNode));
        }
        YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)curNode);
        for (YangLeaf leaf : leavesHolder.getListOfLeaf()) {
            this.addLeafInfoToTempFiles((JavaLeafInfoContainer)((Object)leaf), config, curNode, false);
        }
        for (YangLeafList leafList : leavesHolder.getListOfLeafList()) {
            this.addLeafInfoToTempFiles((JavaLeafInfoContainer)((Object)leafList), config, curNode, true);
        }
    }

    protected void addOperationTypeToTempFiles(YangNode curNode, YangPluginConfig config) throws IOException {
        JavaQualifiedTypeInfoTranslator typeInfo = new JavaQualifiedTypeInfoTranslator();
        typeInfo.setClassInfo("OnosYangOpType");
        JavaFileInfoTranslator curInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        JavaFileInfoTranslator info = curNode instanceof RpcNotificationContainer ? ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo() : ((JavaFileInfoContainer)((Object)this.getModuleNode(curNode))).getJavaFileInfo();
        typeInfo.setPkgInfo(info.getPackage().toLowerCase() + "." + YangIoUtils.getCapitalCase(info.getJavaName()));
        String curNodeName = YangIoUtils.getCapitalCase(curInfo.getJavaName());
        boolean isQualified = false;
        if (!(curNode instanceof RpcNotificationContainer)) {
            isQualified = this.javaImportData.addImportInfo(typeInfo, curNodeName, curInfo.getPackage());
        }
        JavaAttributeInfo attributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, "yang" + curNodeName + "OpType", null, isQualified, false);
        this.addJavaSnippetInfoToApplicableTempFiles(attributeInfo, config);
    }

    private YangNode getModuleNode(YangNode curNode) {
        YangNode tempNode = curNode.getParent();
        while (!(tempNode instanceof RpcNotificationContainer)) {
            tempNode = tempNode.getParent();
        }
        return tempNode;
    }

    protected void addValueLeafFlag(YangPluginConfig config, YangNode node) throws IOException {
        JavaFileInfoTranslator info = ((JavaFileInfoContainer)((Object)node)).getJavaFileInfo();
        JavaQualifiedTypeInfoTranslator typeInfo = new JavaQualifiedTypeInfoTranslator();
        typeInfo.setClassInfo("BitSet");
        typeInfo.setPkgInfo("java.util");
        this.getJavaImportData().addImportInfo(typeInfo, info.getJavaName(), info.getPackage());
        JavaAttributeInfo attributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, "valueLeafFlags", null, false, false);
        this.addJavaSnippetInfoToApplicableTempFiles(attributeInfo, config);
    }

    protected void addSelectLeafFlag(YangPluginConfig config) throws IOException {
        JavaQualifiedTypeInfoTranslator typeInfo = new JavaQualifiedTypeInfoTranslator();
        typeInfo.setClassInfo("BitSet");
        typeInfo.setPkgInfo("java.util");
        JavaAttributeInfo attributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, "selectLeafFlags", null, false, false);
        this.addJavaSnippetInfoToApplicableTempFiles(attributeInfo, config);
    }

    protected void addIsSubTreeFilteredFlag(YangPluginConfig config) throws IOException {
        JavaQualifiedTypeInfoTranslator typeInfo = new JavaQualifiedTypeInfoTranslator();
        typeInfo.setClassInfo("boolean");
        typeInfo.setPkgInfo(null);
        JavaAttributeInfo attributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, "isSubTreeFiltered", null, false, false);
        this.addJavaSnippetInfoToApplicableTempFiles(attributeInfo, config);
    }

    protected void addYangAugmentedMap(YangPluginConfig config, YangNode curNode) throws IOException {
        JavaFileInfoTranslator info = ((JavaCodeGeneratorInfo)((Object)curNode)).getJavaFileInfo();
        JavaQualifiedTypeInfoTranslator typeInfo = new JavaQualifiedTypeInfoTranslator();
        typeInfo.setClassInfo("Map<Class<?>, Object>");
        typeInfo.setPkgInfo(null);
        typeInfo.setForInterface(false);
        JavaAttributeInfo attributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, "yangAugmentedInfoMap", null, false, false);
        this.addImportInfoOfNode("Map", "java.util", YangIoUtils.getCapitalCase(info.getJavaName()), info.getPackage(), true);
        this.addImportInfoOfNode("HashMap", "java.util", YangIoUtils.getCapitalCase(info.getJavaName()), info.getPackage(), false);
        if (curNode.isOpTypeReq()) {
            this.addImportInfoOfNode("InvocationTargetException", "java.lang.reflect", YangIoUtils.getCapitalCase(info.getJavaName()), info.getPackage(), false);
        }
        this.addJavaSnippetInfoToApplicableTempFiles(attributeInfo, config);
    }

    private JavaQualifiedTypeInfoTranslator addImportInfoOfNode(String cls, String pkg, String nodeName, String nodePkg, boolean isForInterface) {
        JavaQualifiedTypeInfoTranslator typeInfo = new JavaQualifiedTypeInfoTranslator();
        typeInfo.setClassInfo(cls);
        typeInfo.setPkgInfo(pkg);
        typeInfo.setForInterface(isForInterface);
        this.getJavaImportData().addImportInfo(typeInfo, nodeName, nodePkg);
        return typeInfo;
    }

    void addJavaSnippetInfoToApplicableTempFiles(JavaAttributeInfo newAttrInfo, YangPluginConfig pluginConfig) throws IOException {
        boolean subTreeForChild;
        this.isAttributePresent = true;
        String attrName = newAttrInfo.getAttributeName();
        boolean required = !attrName.equals("valueLeafFlags") && !attrName.equals("selectLeafFlags") && !attrName.equals("yangAugmentedInfoMap");
        boolean bl = subTreeForChild = this.tempFlagSet(0x2000000) && newAttrInfo.getAttributeType() == null && !attrName.contains("OpType") && required && !attrName.equals("isSubTreeFiltered");
        if (this.tempFlagSet(1)) {
            this.addAttribute(newAttrInfo);
        }
        if (this.tempFlagSet(2) && !attrName.equals("isSubTreeFiltered")) {
            this.addGetterForInterface(newAttrInfo);
        }
        if (this.tempFlagSet(8) && required && !attrName.equals("isSubTreeFiltered")) {
            this.addSetterForInterface(newAttrInfo);
        }
        if (this.tempFlagSet(16) && required) {
            this.addSetterImpl(newAttrInfo);
        }
        if (this.tempFlagSet(64)) {
            this.addHashCodeMethod(newAttrInfo);
        }
        if (this.tempFlagSet(128)) {
            this.addEqualsMethod(newAttrInfo);
        }
        if (this.tempFlagSet(256)) {
            this.addToStringMethod(newAttrInfo);
        }
        if (this.tempFlagSet(0x4000000)) {
            // empty if block
        }
        boolean listAttr = newAttrInfo.isListAttr();
        if (this.tempFlagSet(0x200000) && listAttr) {
            this.addAddToListImpl(newAttrInfo);
        }
        if (this.tempFlagSet(0x100000) && listAttr) {
            this.addAddToListInterface(newAttrInfo);
        }
        YangType<?> attrType = newAttrInfo.getAttributeType();
        if (subTreeForChild) {
            this.addSubtreeFilteringForChildNode(newAttrInfo);
        }
        if (this.tempFlagSet(0x800000) && !listAttr && attrType != null) {
            this.addSubTreeFilteringForLeaf(newAttrInfo);
        }
        if (this.tempFlagSet(0x1000000) && listAttr && attrType != null) {
            this.addSubtreeFilteringForLeafList(newAttrInfo);
        }
        if (this.tempFlagSet(0x400000) && !listAttr && attrType != null) {
            ++this.leafCount;
            this.addLeafIdAttributes(newAttrInfo, this.leafCount);
        }
        if (!(newAttrInfo.isIntConflict() || newAttrInfo.isLongConflict() || newAttrInfo.isShortConflict())) {
            if (this.tempFlagSet(4)) {
                this.addGetterImpl(newAttrInfo);
            }
            if (this.tempFlagSet(2048)) {
                JavaQualifiedTypeInfoTranslator typeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedInfoOfFromString(newAttrInfo, pluginConfig.getConflictResolver());
                JavaAttributeInfo fromStringAttributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(typeInfo, newAttrInfo.getAttributeName(), attrType, this.getIsQualifiedAccessOrAddToImportList(typeInfo), false);
                this.addFromStringMethod(newAttrInfo, fromStringAttributeInfo);
            }
        }
    }

    protected String getJavaClassName(String suffix) {
        return YangIoUtils.getCapitalCase(this.javaFileInfo.getJavaName()) + suffix;
    }

    private String getImplClassName(YangNode node) {
        if (node instanceof RpcNotificationContainer) {
            return this.getGeneratedJavaClassName() + "OpParam";
        }
        return "Default" + this.getGeneratedJavaClassName();
    }

    private String getDirPath() {
        return this.javaFileInfo.getPackageFilePath();
    }

    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        if (curNode.isOpTypeReq()) {
            this.addImportInfoOfNode("BitSet", "java.util", this.getGeneratedJavaClassName(), this.getJavaFileInfo().getPackage(), false);
        }
        if (this.isAttributePresent) {
            this.addImportInfoOfNode("Objects", "java.util", this.getGeneratedJavaClassName(), this.getJavaFileInfo().getPackage(), false);
            this.addImportInfoOfNode("MoreObjects", "com.google.common.base", this.getGeneratedJavaClassName(), this.getJavaFileInfo().getPackage(), false);
        }
        List<String> imports = TranslatorUtils.getBeanFiles(curNode).getJavaImportData().getImports(true);
        JavaIdentifierSyntax.createPackage(curNode);
        if ((fileType & 1) != 0 || (fileType & 2) != 0) {
            this.interfaceJavaFileHandle = this.getJavaFileHandle(this.getJavaClassName(INTERFACE_FILE_NAME_SUFFIX));
            this.interfaceJavaFileHandle = JavaFileGenerator.generateInterfaceFile(this.interfaceJavaFileHandle, imports, curNode, this.isAttributePresent);
            if ((fileType & 2) != 0) {
                this.builderInterfaceJavaFileHandle = this.getJavaFileHandle(this.getJavaClassName(BUILDER_INTERFACE_FILE_NAME_SUFFIX));
                this.builderInterfaceJavaFileHandle = JavaFileGenerator.generateBuilderInterfaceFile(this.builderInterfaceJavaFileHandle, curNode, this.isAttributePresent);
                YangIoUtils.mergeJavaFiles(this.builderInterfaceJavaFileHandle, this.interfaceJavaFileHandle);
            }
            YangIoUtils.insertDataIntoJavaFile(this.interfaceJavaFileHandle, "}");
            YangIoUtils.validateLineLength(this.interfaceJavaFileHandle);
        }
        imports = TranslatorUtils.getBeanFiles(curNode).getJavaImportData().getImports(false);
        if (!curNode.isOpTypeReq()) {
            this.removeCaseParentImport(curNode, imports);
        }
        if ((fileType & 4) != 0 || (fileType & 8) != 0) {
            this.implClassJavaFileHandle = this.getJavaFileHandle(this.getImplClassName(curNode));
            this.implClassJavaFileHandle = JavaFileGenerator.generateDefaultClassFile(this.implClassJavaFileHandle, curNode, this.isAttributePresent, imports);
            if ((fileType & 4) != 0) {
                this.builderClassJavaFileHandle = this.getJavaFileHandle(this.getJavaClassName(BUILDER_CLASS_FILE_NAME_SUFFIX));
                this.builderClassJavaFileHandle = JavaFileGenerator.generateBuilderClassFile(this.builderClassJavaFileHandle, curNode, this.isAttributePresent);
                YangIoUtils.mergeJavaFiles(this.builderClassJavaFileHandle, this.implClassJavaFileHandle);
            }
            YangIoUtils.insertDataIntoJavaFile(this.implClassJavaFileHandle, "}");
            YangIoUtils.validateLineLength(this.implClassJavaFileHandle);
        }
        if (curNode instanceof YangList) {
            YangList list = (YangList)curNode;
            YangDataStructure data = MethodsGenerator.getYangDataStructure(list.getCompilerAnnotation());
            if (list.isConfig() && data == YangDataStructure.MAP) {
                File keyClassJavaFileHandle = this.getJavaFileHandle(this.getJavaClassName(KEY_CLASS_FILE_NAME_SUFFIX));
                JavaFileGenerator.generateKeyClassFile(keyClassJavaFileHandle, curNode);
            }
        }
        this.freeTemporaryResources(false);
    }

    private void removeCaseParentImport(YangNode node, List<String> imports) {
        YangNode parent = node.getParent();
        JavaFileInfoTranslator info = ((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo();
        String impt = StringGenerator.getImportString(info.getPackage(), YangIoUtils.getCapitalCase(info.getJavaName()));
        imports.remove(impt);
    }

    public void freeTemporaryResources(boolean errorOccurred) throws IOException {
        if (this.javaFlagSet(1)) {
            FileSystemUtil.closeFile(this.interfaceJavaFileHandle, errorOccurred);
        }
        if (this.javaFlagSet(4)) {
            FileSystemUtil.closeFile(this.builderClassJavaFileHandle);
        }
        if (this.javaFlagSet(2)) {
            FileSystemUtil.closeFile(this.builderInterfaceJavaFileHandle);
        }
        if (this.javaFlagSet(8)) {
            FileSystemUtil.closeFile(this.implClassJavaFileHandle, errorOccurred);
        }
        if (this.tempFlagSet(4)) {
            FileSystemUtil.closeFile(this.getterImplTempFileHandle);
        }
        if (this.tempFlagSet(1)) {
            FileSystemUtil.closeFile(this.attributesTempFileHandle);
        }
        if (this.tempFlagSet(64)) {
            FileSystemUtil.closeFile(this.hashCodeImplTempFileHandle);
        }
        if (this.tempFlagSet(256)) {
            FileSystemUtil.closeFile(this.toStringImplTempFileHandle);
        }
        if (this.tempFlagSet(128)) {
            FileSystemUtil.closeFile(this.equalsImplTempFileHandle);
        }
        if (this.tempFlagSet(2048)) {
            FileSystemUtil.closeFile(this.fromStringImplTempFileHandle);
        }
        if (this.tempFlagSet(0x200000)) {
            FileSystemUtil.closeFile(this.addToListImplTempFileHandle);
        }
        if (this.tempFlagSet(0x100000)) {
            FileSystemUtil.closeFile(this.addToListInterfaceTempFileHandle);
        }
        if (this.tempFlagSet(0x400000)) {
            FileSystemUtil.closeFile(this.leafIdAttributeTempFileHandle);
        }
        if (this.tempFlagSet(0x800000)) {
            FileSystemUtil.closeFile(this.subtreeFilteringForLeafTempFileHandle);
        }
        if (this.tempFlagSet(0x1000000)) {
            FileSystemUtil.closeFile(this.getSubtreeFilteringForListTempFileHandle);
        }
        if (this.tempFlagSet(0x2000000)) {
            FileSystemUtil.closeFile(this.getSubtreeFilteringForChildNodeTempFileHandle);
        }
        if (this.tempFlagSet(0x4000000)) {
            FileSystemUtil.closeFile(this.editContentTempFileHandle);
        }
    }

    protected boolean getIsQualifiedAccessOrAddToImportList(JavaQualifiedTypeInfo importInfo) {
        return this.javaImportData.addImportInfo((JavaQualifiedTypeInfoTranslator)importInfo, this.getGeneratedJavaClassName(), this.javaFileInfo.getPackage());
    }

    public File getAddToListInterfaceTempFileHandle() {
        return this.addToListInterfaceTempFileHandle;
    }

    public File getAddToListImplTempFileHandle() {
        return this.addToListImplTempFileHandle;
    }

    public File getLeafIdAttributeTempFileHandle() {
        return this.leafIdAttributeTempFileHandle;
    }

    void setRootNode(boolean rootNode) {
        this.rootNode = rootNode;
    }

    public File getSubtreeFilteringForLeafTempFileHandle() {
        return this.subtreeFilteringForLeafTempFileHandle;
    }

    public File getEditContentTempFileHandle() {
        return this.editContentTempFileHandle;
    }

    public File getGetSubtreeFilteringForListTempFileHandle() {
        return this.getSubtreeFilteringForListTempFileHandle;
    }

    public File getGetSubtreeFilteringForChildNodeTempFileHandle() {
        return this.getSubtreeFilteringForChildNodeTempFileHandle;
    }

    private boolean javaFlagSet(int flag) {
        return (this.getGeneratedJavaFiles() & flag) != 0;
    }

    private boolean tempFlagSet(int flag) {
        return (this.tempFilesFlagSet & flag) != 0;
    }

    public void setAttrNode(YangNode attrNode) {
        this.attrNode = attrNode;
    }
}

