/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaModuleTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaSubModuleTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaServiceFragmentFiles
extends TempJavaFragmentFiles {
    private static final String RPC_INTERFACE_FILE_NAME = "Rpc";
    private final File rpcInterfaceTempFileHandle;
    private File serviceJavaFileHandle;

    TempJavaServiceFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        this.setJavaExtendsListHolder(new JavaExtendsListHolder());
        this.setJavaImportData(new JavaImportData());
        this.setJavaFileInfo(javaFileInfo);
        this.setAbsoluteDirPath(YangIoUtils.getAbsolutePackagePath(this.getJavaFileInfo().getBaseCodeGenPath(), this.getJavaFileInfo().getPackageFilePath()));
        this.addGeneratedTempFile(8192);
        this.rpcInterfaceTempFileHandle = this.getTemporaryFileHandle(RPC_INTERFACE_FILE_NAME);
    }

    public File getRpcInterfaceTempFileHandle() {
        return this.rpcInterfaceTempFileHandle;
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        JavaFileGeneratorUtils.addResolvedAugmentedDataNodeImports(curNode);
        List<String> imports = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getServiceTempFiles().getJavaImportData().getImports(true);
        JavaIdentifierSyntax.createPackage(curNode);
        boolean notification = false;
        if (curNode instanceof YangJavaModuleTranslator) {
            if (!((YangJavaModuleTranslator)curNode).getNotificationNodes().isEmpty()) {
                notification = true;
            }
        } else if (curNode instanceof YangJavaSubModuleTranslator && !((YangJavaSubModuleTranslator)curNode).getNotificationNodes().isEmpty()) {
            notification = true;
        }
        if (notification) {
            JavaCodeSnippetGen.addListenersImport(curNode, imports, UtilConstants.Operation.ADD);
        }
        this.serviceJavaFileHandle = this.getJavaFileHandle(this.getJavaClassName("Service"));
        JavaFileGenerator.generateServiceInterfaceFile(this.serviceJavaFileHandle, curNode, imports);
        this.freeTemporaryResources(false);
    }

    private void addRpcString(JavaAttributeInfo inAttr, JavaAttributeInfo outAttr, String rpcName) throws IOException {
        String rpcInput = null;
        String rpcOutput = "void";
        String rpcIn = "";
        if (inAttr != null) {
            rpcInput = YangIoUtils.getCapitalCase(inAttr.getAttributeName());
        }
        if (outAttr != null) {
            rpcOutput = YangIoUtils.getCapitalCase(outAttr.getAttributeName());
        }
        if (rpcInput != null) {
            rpcIn = "inputVar";
        }
        this.appendToFile(this.rpcInterfaceTempFileHandle, JavaDocGen.generateJavaDocForRpc(rpcName, rpcIn, rpcOutput) + MethodsGenerator.getRpcServiceMethod(rpcName, rpcInput, rpcOutput));
    }

    public void addJavaSnippetInfoToApplicableTempFiles(JavaAttributeInfo inAttr, JavaAttributeInfo outAttr, String rpcName) throws IOException {
        this.addRpcString(inAttr, outAttr, rpcName);
    }

    public JavaAttributeInfo getChildNodeAsAttributeInParentService(YangNode childNode, YangNode parentNode, String rpcName) {
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)childNode)).getJavaFileInfo();
        String childNodeName = fileInfo.getJavaName();
        if (childNodeName == null) {
            childNodeName = childNode instanceof YangInput ? rpcName + "-" + "input" : rpcName + "-" + "output";
            childNodeName = YangIoUtils.getCamelCase(childNodeName, null);
        }
        JavaQualifiedTypeInfoTranslator qualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(childNode, YangIoUtils.getCapitalCase(childNodeName));
        if (!(parentNode instanceof TempJavaCodeFragmentFilesContainer)) {
            throw new TranslatorException("Parent node does not have file info");
        }
        boolean isQualified = this.addImportToService(qualifiedTypeInfo, parentNode);
        return JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, childNodeName, null, isQualified, false);
    }

    private boolean addImportToService(JavaQualifiedTypeInfoTranslator importInfo, YangNode curNode) {
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String name = fileInfo.getJavaName();
        String clsInfo = importInfo.getClassInfo();
        StringBuilder className = new StringBuilder().append(YangIoUtils.getCapitalCase(name)).append("Service");
        return clsInfo.contentEquals("Service") || clsInfo.contentEquals(className) || this.getJavaImportData().addImportInfo(importInfo, className.toString(), fileInfo.getPackage());
    }

    public void addAugmentedRpcMethod(RpcNotificationContainer module) throws IOException {
        JavaAttributeInfo in = null;
        JavaAttributeInfo out = null;
        for (YangAugment info : module.getAugmentList()) {
            YangRpc rpc;
            YangInput input = (YangInput)info.getAugmentedNode();
            if (input == null || this.validateForIntraFile(module, (RpcNotificationContainer)((Object)(rpc = (YangRpc)input.getParent()).getParent()))) continue;
            String rpcName = YangIoUtils.getCamelCase(rpc.getName(), null);
            for (YangNode rpcChild = rpc.getChild(); rpcChild != null; rpcChild = rpcChild.getNextSibling()) {
                if (rpcChild instanceof YangInput) {
                    in = this.getChildNodeAsAttributeInParentService(rpcChild, (YangNode)((Object)module), rpcName);
                }
                if (!(rpcChild instanceof YangOutput)) continue;
                out = this.getChildNodeAsAttributeInParentService(rpcChild, (YangNode)((Object)module), rpcName);
            }
            this.addJavaSnippetInfoToApplicableTempFiles(in, out, rpcName);
        }
    }

    private boolean validateForIntraFile(RpcNotificationContainer parent, RpcNotificationContainer curModule) {
        return parent.getPrefix().equals(curModule.getPrefix());
    }

    @Override
    public void freeTemporaryResources(boolean errorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.serviceJavaFileHandle, errorOccurred);
        FileSystemUtil.closeFile(this.rpcInterfaceTempFileHandle);
        FileSystemUtil.closeFile(this.getGetterInterfaceTempFileHandle());
        FileSystemUtil.closeFile(this.getSetterInterfaceTempFileHandle());
        FileSystemUtil.closeFile(this.getSetterImplTempFileHandle());
        super.freeTemporaryResources(errorOccurred);
    }
}

