/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.javamodel;

import java.io.IOException;
import java.util.ArrayList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.javadatamodel.YangJavaModule;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorErrorType;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class YangJavaModuleTranslator
extends YangJavaModule
implements JavaCodeGeneratorInfo,
JavaCodeGenerator {
    private static final long serialVersionUID = 806201625L;
    private transient TempJavaCodeFragmentFiles tempFileHandle;

    public YangJavaModuleTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
        this.notificationNodes = new ArrayList();
        this.getJavaFileInfo().setGeneratedFileTypes(8223);
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("Missing java info in java datamodel node " + this.getName());
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempFileHandle;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempFileHandle = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        String modulePkg = JavaIdentifierSyntax.getRootPackage(this.getVersion(), this.getModuleNamespace(), this.getRevision(), yangPlugin.getConflictResolver());
        if (this.isNotificationChildNodePresent(this)) {
            this.getJavaFileInfo().setGeneratedFileTypes(this.getJavaFileInfo().getGeneratedFileTypes() | 0x700);
        }
        try {
            YangJavaModelUtils.generateCodeOfRootNode(this, yangPlugin, modulePkg);
            this.tempFileHandle.getServiceTempFiles().addAugmentedRpcMethod(this);
        }
        catch (IOException e) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_ENTRY, this, e.getLocalizedMessage()));
        }
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
        try {
            if ((this.getJavaFileInfo().getGeneratedFileTypes() & 0x700) != 0) {
                this.getTempJavaCodeFragmentFiles().generateJavaFile(1792, this);
            }
            if (!YangJavaModelUtils.isRootNodesCodeGenRequired(this)) {
                if (this.getChild() != null) {
                    YangJavaModelUtils.generateInterfaceFileForNonDataNodes(this);
                }
            } else {
                this.getTempJavaCodeFragmentFiles().generateJavaFile(8207, this);
                if (this.getJavaFileInfo().getPluginConfig().getCodeGenerateForSbi() == null || !this.getJavaFileInfo().getPluginConfig().getCodeGenerateForSbi().equals("sbi")) {
                    this.getTempJavaCodeFragmentFiles().generateJavaFile(16, this);
                }
            }
            YangIoUtils.searchAndDeleteTempDir(this.getJavaFileInfo().getBaseCodeGenPath() + this.getJavaFileInfo().getPackageFilePath());
            YangIoUtils.removeEmptyDirectory(this.getJavaFileInfo().getBaseCodeGenPath() + this.getJavaFileInfo().getPackageFilePath());
        }
        catch (IOException e) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_EXIT, this, e.getLocalizedMessage()));
        }
    }

    private void addToNotificationList(YangNode curNode) {
        this.notificationNodes.add(curNode);
    }

    private boolean isNotificationChildNodePresent(YangNode rootNode) {
        for (YangNode childNode = rootNode.getChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!(childNode instanceof YangNotification)) continue;
            this.addToNotificationList(childNode);
        }
        return !this.notificationNodes.isEmpty();
    }
}

