/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.io.IOException;
import org.onosproject.yangutils.datamodel.LocationInfo;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorErrorType;

public final class TranslatorUtils {
    private TranslatorUtils() {
    }

    public static String getErrorMsg(TranslatorErrorType errorType, YangSchemaNode node, String localizedMsg) {
        return TranslatorUtils.getErrorMsg(errorType, node) + localizedMsg;
    }

    public static String getErrorMsg(TranslatorErrorType errorType, YangSchemaNode node) {
        return errorType.prefix() + " in " + node.getName() + TranslatorUtils.getLocationMsg(node);
    }

    public static String getErrorMsgForCodeGenerator(TranslatorErrorType errorType, LocationInfo location) {
        return errorType.prefix() + TranslatorUtils.getLocationMsg(location);
    }

    private static String getLocationMsg(LocationInfo location) {
        return " at " + location.getLineNumber() + " at " + location.getCharPosition() + " in " + location.getFileName();
    }

    public static TempJavaBeanFragmentFiles getBeanFiles(YangNode curNode) {
        return ((TempJavaCodeFragmentFilesContainer)((Object)curNode)).getTempJavaCodeFragmentFiles().getBeanTempFiles();
    }

    public static TempJavaBeanFragmentFiles getBeanFiles(JavaCodeGeneratorInfo info) {
        return info.getTempJavaCodeFragmentFiles().getBeanTempFiles();
    }

    public static TempJavaTypeFragmentFiles getTypeFiles(YangNode curNode) {
        return ((TempJavaCodeFragmentFilesContainer)((Object)curNode)).getTempJavaCodeFragmentFiles().getTypeTempFiles();
    }

    static String addDefaultConstructor(YangNode node, String modifier, String toAppend) throws IOException {
        return ((TempJavaCodeFragmentFilesContainer)((Object)node)).getTempJavaCodeFragmentFiles().addDefaultConstructor(modifier, toAppend);
    }
}

