/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.utils.io.impl;

import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaDocGen {
    private JavaDocGen() {
    }

    public static String getJavaDoc(JavaDocType type, String name, boolean isList, String compilerAnnotation) {
        name = YangIoUtils.getSmallCase(name);
        switch (type) {
            case DEFAULT_CLASS: {
                return JavaDocGen.generateForClass(name, isList);
            }
            case BUILDER_CLASS: {
                return JavaDocGen.generateForBuilderClass(name);
            }
            case OPERATION_CLASS: {
                return JavaDocGen.generateForOpParamClass(name);
            }
            case OPERATION_BUILDER_CLASS: {
                return JavaDocGen.generateForOpParamClass(name);
            }
            case INTERFACE: {
                return JavaDocGen.generateForInterface(name);
            }
            case BUILDER_INTERFACE: {
                return JavaDocGen.generateForBuilderInterface(name);
            }
            case PACKAGE_INFO: {
                return JavaDocGen.generateForPackage(name, isList);
            }
            case GETTER_METHOD: {
                return JavaDocGen.generateForGetters(name, isList, compilerAnnotation);
            }
            case TYPE_DEF_SETTER_METHOD: {
                return JavaDocGen.generateForTypeDefSetter(name);
            }
            case SETTER_METHOD: {
                return JavaDocGen.generateForSetters(name, isList, compilerAnnotation);
            }
            case MANAGER_SETTER_METHOD: {
                return JavaDocGen.generateForManagerSetters(name, isList, compilerAnnotation);
            }
            case OF_METHOD: {
                return JavaDocGen.generateForOf(name);
            }
            case DEFAULT_CONSTRUCTOR: {
                return JavaDocGen.generateForDefaultConstructors(name);
            }
            case BUILD_METHOD: {
                return JavaDocGen.generateForBuild(name);
            }
            case TYPE_CONSTRUCTOR: {
                return JavaDocGen.generateForTypeConstructor(name);
            }
            case FROM_METHOD: {
                return JavaDocGen.generateForFromString(name);
            }
            case ENUM_CLASS: {
                return JavaDocGen.generateForEnum(name);
            }
            case ENUM_ATTRIBUTE: {
                return JavaDocGen.generateForEnumAttr(name);
            }
            case RPC_INTERFACE: {
                return JavaDocGen.generateForRpcService(name);
            }
            case RPC_MANAGER: {
                return JavaDocGen.generateForClass(name, false);
            }
            case EVENT: {
                return JavaDocGen.generateForEvent(name);
            }
            case EVENT_LISTENER: {
                return JavaDocGen.generateForEventListener(name);
            }
            case EVENT_SUBJECT_CLASS: {
                return JavaDocGen.generateForClass(name, false);
            }
            case ADD_TO_LIST: {
                return JavaDocGen.generateForAddToList(name, compilerAnnotation);
            }
        }
        return JavaDocGen.generateForConstructors(name);
    }

    private static String generateForEnumAttr(String name) {
        return JavaDocGen.getJavaDocForClass(name, " * Represents ", "    ");
    }

    public static String enumJavaDocForInnerClass(String name) {
        return JavaDocGen.getJavaDocForClass(name, " * Represents ", "        ");
    }

    public static String generateJavaDocForRpc(String rpcName, String inputName, String outputName) {
        String javadoc = JavaDocGen.getJavaDocStartLine(rpcName, " * Service interface of ") + JavaDocGen.getJavaDocEmptyAsteriskLine();
        if (!inputName.equals("")) {
            javadoc = javadoc + JavaDocGen.getInputString(inputName, rpcName);
        }
        if (!outputName.equals("void")) {
            javadoc = javadoc + JavaDocGen.getOutputString(YangIoUtils.getSmallCase(outputName), rpcName);
        }
        return javadoc + JavaDocGen.getJavaDocEndLine();
    }

    private static String getOutputString(String outputName, String rpcName) {
        return "     * @return " + outputName + " " + "output of service interface " + rpcName + "\n";
    }

    private static String getInputString(String inputName, String rpcName) {
        if (inputName.isEmpty()) {
            return null;
        }
        return "     * @param " + inputName + " " + "input of service interface " + rpcName + "\n";
    }

    private static String generateForRpcService(String interfaceName) {
        return JavaDocGen.getJavaDocForClass(interfaceName, " * Abstraction of an entity which represents the functionality of ", "");
    }

    private static String generateForEvent(String name) {
        return JavaDocGen.getJavaDocForClass(name, " * Represents event implementation of ", "");
    }

    private static String generateForEventListener(String name) {
        return JavaDocGen.getJavaDocForClass(name, " * Abstraction for event listener of ", "");
    }

    private static String generateForGetters(String attribute, boolean isList, String compilerAnnotation) {
        String getter = JavaDocGen.getJavaDocStartLine(attribute, " * Returns the attribute ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + "    " + " * @return " + attribute + " ";
        getter = JavaDocGen.getParamForAnnotation(getter, compilerAnnotation, isList) + attribute + "\n" + JavaDocGen.getJavaDocEndLine();
        return getter;
    }

    private static String generateForSetters(String attribute, boolean isList, String compilerAnnotation) {
        String setter = JavaDocGen.getJavaDocStartLine(attribute, " * Returns the builder object of ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + "    " + " * @param " + attribute + " ";
        setter = JavaDocGen.getParamForAnnotation(setter, compilerAnnotation, isList) + attribute + "\n" + JavaDocGen.getJavaDocReturnLine(attribute) + JavaDocGen.getJavaDocEndLine();
        return setter;
    }

    private static String generateForManagerSetters(String attribute, boolean isList, String compilerAnnotation) {
        String setter = JavaDocGen.getJavaDocStartLine(attribute, " * Sets the value to attribute ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + "    " + " * @param " + attribute + " ";
        setter = JavaDocGen.getParamForAnnotation(setter, compilerAnnotation, isList) + attribute + "\n" + JavaDocGen.getJavaDocEndLine();
        return setter;
    }

    private static String getParamForAnnotation(String setter, String compilerAnnotation, boolean isList) {
        if (compilerAnnotation != null) {
            compilerAnnotation = compilerAnnotation.toLowerCase();
            switch (compilerAnnotation = YangIoUtils.getCapitalCase(compilerAnnotation)) {
                case "Queue": {
                    String attributeParam = "Queue".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
                case "Set": {
                    String attributeParam = "Set".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
                case "List": {
                    String attributeParam = "List".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
                case "Map": {
                    String attributeParam = "Map".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
            }
        } else if (isList) {
            String attributeParam = "List".toLowerCase() + " " + "of" + " ";
            setter = setter + attributeParam;
        } else {
            setter = setter + "value" + " " + "of" + " ";
        }
        return setter;
    }

    private static String generateForOf(String attribute) {
        return JavaDocGen.getJavaDocStartLine(attribute, " * Returns the object of ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine(attribute, "value") + JavaDocGen.getJavaDocReturnLine(attribute) + JavaDocGen.getJavaDocEndLine();
    }

    private static String generateForFromString(String attribute) {
        return JavaDocGen.getJavaDocStartLine(attribute, " * Returns the object of " + attribute + " " + "fromString" + " " + "input" + " " + "String" + " ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine("input String", "valInString") + JavaDocGen.getJavaDocReturnLine(attribute) + JavaDocGen.getJavaDocEndLine();
    }

    private static String generateForTypeDefSetter(String attribute) {
        return JavaDocGen.getJavaDocStartLine(attribute, " * Sets the value of ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine(attribute, "value") + JavaDocGen.getJavaDocEndLine();
    }

    private static String generateForClass(String className, boolean isForDefaultClass) {
        return JavaDocGen.getJavaDocForDefaultClass(className, " * Represents the implementation of ", "", isForDefaultClass);
    }

    private static String addFlagJavaDoc() {
        return " *\n * <p>\n * valueLeafFlags identify the leafs whose value are explicitly set\n * Applicable in protocol edit and query operation.\n * </p>\n *\n * <p>\n * selectLeafFlags identify the leafs to be selected, in a query operation.\n * </p>\n *\n * <p>\n * Operation type specify the node specific operation in protocols like NETCONF.\n * Applicable in protocol edit operation, not applicable in query operation.\n * </p>\n";
    }

    private static String generateForEnum(String className) {
        return JavaDocGen.getJavaDocForClass(className, " * Represents ENUM data of ", "");
    }

    private static String generateForBuilderClass(String className) {
        return JavaDocGen.getJavaDocForClass(className, " * Represents the builder implementation of ", "");
    }

    private static String generateForOpParamClass(String className) {
        return JavaDocGen.getJavaDocForClass(className, " * Represents operation parameter implementation of ", "");
    }

    private static String generateForInterface(String interfaceName) {
        return JavaDocGen.getJavaDocForClass(interfaceName, " * Abstraction of an entity which represents the functionality of ", "");
    }

    private static String generateForBuilderInterface(String builderForName) {
        return JavaDocGen.getJavaDocForClass(builderForName, " * Builder for ", "");
    }

    private static String generateForPackage(String packageName, boolean isChildNode) {
        if (isChildNode) {
            return JavaDocGen.getJavaDocForClass(packageName + "'s children nodes", " * Implementation of YANG node ", "");
        }
        return JavaDocGen.getJavaDocForClass(packageName, " * Implementation of YANG node ", "");
    }

    private static String generateForDefaultConstructors(String className) {
        return JavaDocGen.getJavaDocStartLine(className, " * Creates an instance of ") + JavaDocGen.getJavaDocEndLine();
    }

    private static String generateForConstructors(String className) {
        return JavaDocGen.getJavaDocStartLine(className, " * Creates an instance of ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine("builder object of " + className, "builderObject") + JavaDocGen.getJavaDocEndLine();
    }

    private static String generateForBuild(String buildName) {
        return JavaDocGen.getJavaDocStartLine(buildName, " * Builds object of ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocReturnLine(buildName) + JavaDocGen.getJavaDocEndLine();
    }

    private static String generateForTypeConstructor(String attribute) {
        return JavaDocGen.getJavaDocStartLine(attribute, " * Creates an instance of ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine(attribute, attribute) + JavaDocGen.getJavaDocEndLine();
    }

    public static String generateForAddAugmentation() {
        return JavaDocGen.getJavaDocStartLine("yangAugmentedInfo", " * Sets the value of ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine("yangAugmentedInfo", "value") + JavaDocGen.getJavaDocParamLine("yangAugmentedInfo", "classObject") + JavaDocGen.getJavaDocEndLine();
    }

    public static String generateForGetAugmentation() {
        return "\n" + JavaDocGen.getJavaDocStartLine("yangAugmentedInfo", " * Returns the attribute ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine("yangAugmentedInfo", "classObject") + JavaDocGen.getJavaDocReturnLine("YangAugmentedInfo") + JavaDocGen.getJavaDocEndLine();
    }

    public static String generateForValidatorMethod() {
        return JavaDocGen.getJavaDocStartLine("validateRange", " * Validates if value is in given range.") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine("minRange", "minRange") + JavaDocGen.getJavaDocParamLine("maxRange", "minRange") + JavaDocGen.getJavaDocReturnLine(" true if value is in range") + JavaDocGen.getJavaDocEndLine();
    }

    public static String generateForGetMethodWithAttribute(String attribute) {
        attribute = YangIoUtils.getSmallCase(attribute);
        return JavaDocGen.getJavaDocStartLine(attribute, " * Returns the attribute ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocParamLine(attribute, attribute) + JavaDocGen.getJavaDocReturnLine(attribute) + JavaDocGen.getJavaDocEndLine();
    }

    private static String generateForAddToList(String attribute, String annotation) {
        StringBuilder javadoc = new StringBuilder();
        javadoc.append(JavaDocGen.getJavaDocStartLine(attribute, " * Adds to the list of ")).append(JavaDocGen.getJavaDocEmptyAsteriskLine());
        if (annotation != null) {
            annotation = annotation.toLowerCase();
            switch (annotation = YangIoUtils.getCapitalCase(annotation)) {
                case "Map": {
                    javadoc.append(JavaDocGen.getJavaDocParamLine(attribute, attribute + "Keys")).append(JavaDocGen.getJavaDocParamLine(attribute, attribute + "Value"));
                    break;
                }
                default: {
                    javadoc.append(JavaDocGen.getJavaDocParamLine(attribute, "addTo"));
                }
            }
        }
        javadoc.append(JavaDocGen.getJavaDocReturnLine("builder object of " + attribute)).append(JavaDocGen.getJavaDocEndLine());
        return javadoc.toString();
    }

    public static String generateForBuilderMethod(String attribute) {
        return JavaDocGen.getJavaDocStartLine(attribute + "Builder", " * Returns the attribute ") + JavaDocGen.getJavaDocEmptyAsteriskLine() + JavaDocGen.getJavaDocReturnLine(attribute + "Builder") + JavaDocGen.getJavaDocEndLine();
    }

    private static String getJavaDocForClass(String name, String type, String indent) {
        return "\n" + indent + "/**\n" + indent + type + YangIoUtils.getSmallCase(name) + "." + "\n" + indent + " */\n";
    }

    private static String getJavaDocForDefaultClass(String name, String type, String indent, boolean isForDefaultClass) {
        String append = JavaDocGen.addFlagJavaDoc();
        if (!isForDefaultClass) {
            append = "";
        }
        return "\n" + indent + "/**\n" + indent + type + YangIoUtils.getSmallCase(name) + "." + "\n" + indent + append + " */\n";
    }

    private static String getJavaDocStartLine(String name, String javaDoc) {
        return "    /**\n    " + javaDoc + YangIoUtils.getSmallCase(name) + "." + "\n";
    }

    private static String getJavaDocEmptyAsteriskLine() {
        return "     *\n";
    }

    private static String getJavaDocParamLine(String name, String paraName) {
        return "     * @param " + YangIoUtils.getSmallCase(paraName) + " " + "value" + " " + "of" + " " + YangIoUtils.getSmallCase(name) + "\n";
    }

    private static String getJavaDocReturnLine(String name) {
        return "     * @return " + YangIoUtils.getSmallCase(name) + "\n";
    }

    private static String getJavaDocEndLine() {
        return "     */\n";
    }

    public static enum JavaDocType {
        DEFAULT_CLASS,
        BUILDER_CLASS,
        INTERFACE,
        BUILDER_INTERFACE,
        PACKAGE_INFO,
        GETTER_METHOD,
        RPC_INTERFACE,
        RPC_MANAGER,
        EVENT,
        EVENT_LISTENER,
        SETTER_METHOD,
        TYPE_DEF_SETTER_METHOD,
        OF_METHOD,
        DEFAULT_CONSTRUCTOR,
        CONSTRUCTOR,
        FROM_METHOD,
        TYPE_CONSTRUCTOR,
        BUILD_METHOD,
        ENUM_CLASS,
        ENUM_ATTRIBUTE,
        MANAGER_SETTER_METHOD,
        EVENT_SUBJECT_CLASS,
        OPERATION_CLASS,
        OPERATION_BUILDER_CLASS,
        ADD_TO_LIST;

    }
}

