/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.YangCommonInfo;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangStatusType;
import org.onosproject.yangutils.datamodel.YangTranslatorOperatorNode;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.exceptions.ErrorMessages;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;

public abstract class YangGrouping
extends YangNode
implements YangLeavesHolder,
YangCommonInfo,
Parsable,
CollisionDetector,
YangTranslatorOperatorNode {
    private static final long serialVersionUID = 806201607L;
    private String description;
    private List<YangLeaf> listOfLeaf = new LinkedList<YangLeaf>();
    private List<YangLeafList> listOfLeafList = new LinkedList<YangLeafList>();
    private String reference;
    private YangStatusType status;
    private int groupingDepth;

    public YangGrouping() {
        super(YangNodeType.GROUPING_NODE, null);
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo context) throws DataModelException {
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier id, YangSchemaNode node) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_NON_DATA_NODE;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<YangLeaf> getListOfLeaf() {
        return Collections.unmodifiableList(this.listOfLeaf);
    }

    @Override
    public void setListOfLeaf(List<YangLeaf> leafsList) {
        this.listOfLeaf = leafsList;
    }

    @Override
    public void addLeaf(YangLeaf leaf) {
        this.listOfLeaf.add(leaf);
    }

    @Override
    public List<YangLeafList> getListOfLeafList() {
        return Collections.unmodifiableList(this.listOfLeafList);
    }

    @Override
    public void setListOfLeafList(List<YangLeafList> listOfLeafList) {
        this.listOfLeafList = listOfLeafList;
    }

    @Override
    public void addLeafList(YangLeafList leafList) {
        this.listOfLeafList.add(leafList);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.GROUPING_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    @Override
    public void detectCollidingChild(String identifierName, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(identifierName, dataType, this);
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (this.getName().equals(identifierName)) {
            throw new DataModelException(ErrorMessages.getErrorMsgCollision("YANG File Error: Identifier collision detected in", this.getName(), this.getLineNumber(), this.getCharPosition(), " grouping ", this.getFileName()));
        }
    }

    @Override
    public void setLeafNameSpaceAndAddToParentSchemaMap() {
        for (YangLeaf yangLeaf : this.listOfLeaf) {
            yangLeaf.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
        for (YangLeafList yangLeafList : this.listOfLeafList) {
            yangLeafList.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
    }

    public int getGroupingDepth() {
        return this.groupingDepth;
    }

    public void setGroupingDepth(int groupingDepth) {
        this.groupingDepth = groupingDepth;
    }
}

