/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.YangCommonInfo;
import org.onosproject.yangutils.datamodel.YangConfig;
import org.onosproject.yangutils.datamodel.YangIfFeature;
import org.onosproject.yangutils.datamodel.YangIfFeatureHolder;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangMust;
import org.onosproject.yangutils.datamodel.YangMustHolder;
import org.onosproject.yangutils.datamodel.YangNamespace;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangStatusType;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangWhen;
import org.onosproject.yangutils.datamodel.YangWhenHolder;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;

public abstract class YangLeaf
extends DefaultLocationInfo
implements YangCommonInfo,
Parsable,
Cloneable,
Serializable,
YangMustHolder,
YangIfFeatureHolder,
YangWhenHolder,
YangSchemaNode,
YangConfig {
    private static final long serialVersionUID = 806201635L;
    private YangSchemaNodeIdentifier yangSchemaNodeIdentifier;
    private boolean isConfig;
    private String description;
    private boolean isMandatory;
    private String reference;
    private YangStatusType status = YangStatusType.CURRENT;
    private String units;
    private YangType<?> dataType;
    private String defaultValueInString;
    private YangWhen when;
    private YangLeavesHolder containedIn;
    private List<YangMust> mustConstraintList = new LinkedList<YangMust>();
    private List<YangIfFeature> ifFeatureList = new LinkedList<YangIfFeature>();
    private YangLeaf referredLeaf;
    private boolean isKeyLeaf;

    @Override
    public boolean isConfig() {
        return this.isConfig;
    }

    @Override
    public void setConfig(boolean isConfig) {
        this.isConfig = isConfig;
    }

    @Override
    public YangWhen getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(YangWhen when) {
        this.when = when;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean isReq) {
        this.isMandatory = isReq;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getDefaultValueInString() {
        return this.defaultValueInString;
    }

    public void setDefaultValueInString(String defaultValueInString) {
        this.defaultValueInString = defaultValueInString;
    }

    public YangType<?> getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isEmptyDataType() {
        return DataModelUtils.validateEmptyDataType(this.dataType);
    }

    public void setDataType(YangType<?> dataType) {
        this.dataType = dataType;
    }

    public YangLeavesHolder getContainedIn() {
        return this.containedIn;
    }

    public void setContainedIn(YangLeavesHolder containedIn) {
        this.containedIn = containedIn;
    }

    public YangLeaf clone() throws CloneNotSupportedException {
        YangLeaf cl = (YangLeaf)super.clone();
        cl.yangSchemaNodeIdentifier = this.yangSchemaNodeIdentifier.clone();
        return cl;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.LEAF_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
        if (this.defaultValueInString != null && !this.defaultValueInString.isEmpty() && this.dataType != null) {
            this.dataType.isValidValue(this.defaultValueInString);
        }
    }

    @Override
    public List<YangMust> getListOfMust() {
        return this.mustConstraintList;
    }

    @Override
    public void setListOfMust(List<YangMust> mustConstraintList) {
        this.mustConstraintList = mustConstraintList;
    }

    @Override
    public void addMust(YangMust must) {
        if (this.getListOfMust() == null) {
            this.setListOfMust(new LinkedList<YangMust>());
        }
        this.getListOfMust().add(must);
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return this.ifFeatureList;
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        if (this.getIfFeatureList() == null) {
            this.setIfFeatureList(new LinkedList<YangIfFeature>());
        }
        this.getIfFeatureList().add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public YangSchemaNodeContextInfo getChildSchema(YangSchemaNodeIdentifier dataNodeIdentifier) throws DataModelException {
        throw new DataModelException("leaf cannot have any child schema nodes " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
    }

    @Override
    public void isValueValid(String value) throws DataModelException {
        this.getDataType().isValidValue(value);
    }

    @Override
    public int getMandatoryChildCount() throws DataModelException {
        throw new DataModelException("Leaf can't have child. " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
    }

    @Override
    public Map<YangSchemaNodeIdentifier, YangSchemaNode> getDefaultChild(YangSchemaNodeIdentifier dataNodeIdentifier) {
        return null;
    }

    @Override
    public boolean isNotificationPresent() throws DataModelException {
        throw new DataModelException("Method is called for node other than module/sub-module.");
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_SINGLE_INSTANCE_LEAF_NODE;
    }

    public void setLeafNameSpaceAndAddToParentSchemaMap(YangNamespace nameSpace) {
        this.setNameSpace(nameSpace);
        ((YangNode)((Object)this.getContainedIn())).processAdditionOfSchemaNodeToCurNodeMap(this.getName(), this.getNameSpace(), this);
    }

    @Override
    public YangSchemaNodeIdentifier getYangSchemaNodeIdentifier() {
        return this.yangSchemaNodeIdentifier;
    }

    public void setYangSchemaNodeIdentifier(YangSchemaNodeIdentifier yangSchemaNodeIdentifier) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier = yangSchemaNodeIdentifier;
    }

    @Override
    public String getName() {
        return this.yangSchemaNodeIdentifier.getName();
    }

    public void setName(String name) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setName(name);
    }

    @Override
    public YangNamespace getNameSpace() {
        return this.yangSchemaNodeIdentifier.getNameSpace();
    }

    public void setNameSpace(YangNamespace namespace) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setNameSpace(namespace);
    }

    @Override
    public YangSchemaNode getNotificationSchemaNode(String notificationNameInEnum) throws DataModelException {
        throw new DataModelException("Method called for schema node other then module/sub-module");
    }

    @Override
    public YangLeaf getReferredSchema() {
        return this.referredLeaf;
    }

    public void setReferredLeaf(YangLeaf leaf) {
        this.referredLeaf = leaf;
    }

    public boolean isKeyLeaf() {
        return this.isKeyLeaf;
    }

    public void setKeyLeaf(boolean keyLeaf) {
        this.isKeyLeaf = keyLeaf;
    }
}

