/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.Resolvable;
import org.onosproject.yangutils.datamodel.YangAppErrorHolder;
import org.onosproject.yangutils.datamodel.YangAppErrorInfo;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangIfFeature;
import org.onosproject.yangutils.datamodel.YangIfFeatureHolder;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangPathArgType;
import org.onosproject.yangutils.datamodel.YangRelativePath;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangXPathResolver;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;

public class YangLeafRef<T>
extends DefaultLocationInfo
implements Cloneable,
Parsable,
Resolvable,
Serializable,
YangIfFeatureHolder,
YangXPathResolver,
YangAppErrorHolder {
    private static final long serialVersionUID = 286201644L;
    private YangType effectiveDataType;
    private T referredLeafOrLeafList;
    private String path;
    private YangPathArgType pathType;
    private List<YangAtomicPath> atomicPath;
    private YangRelativePath relativePath;
    private ResolvableStatus resolvableStatus;
    private boolean requireInstance;
    private List<YangIfFeature> ifFeatureList;
    private YangNode parentNode;
    private Map<String, String> prefixAndNode;
    private boolean inGrouping;
    private YangAppErrorInfo yangAppErrorInfo = new YangAppErrorInfo();

    public Map<String, String> getPrefixAndNode() {
        return this.prefixAndNode;
    }

    public void setPrefixAndNode(Map<String, String> prefixAndNode) {
        this.prefixAndNode = prefixAndNode;
    }

    public YangNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(YangNode parentNode) {
        this.parentNode = parentNode;
    }

    public YangLeafRef() {
        this.prefixAndNode = new HashMap<String, String>();
        this.atomicPath = new ArrayList<YangAtomicPath>();
        this.ifFeatureList = new ArrayList<YangIfFeature>();
        this.yangAppErrorInfo.setErrorTag("data-missing");
        this.yangAppErrorInfo.setErrorAppTag("instance-required");
        this.yangAppErrorInfo.setErrorAppPath("Path to the leafref leaf.");
    }

    public boolean getRequireInstance() {
        return this.requireInstance;
    }

    public void setRequireInstance(boolean requireInstance) {
        this.requireInstance = requireInstance;
    }

    public YangType getEffectiveDataType() {
        return this.effectiveDataType;
    }

    public void setEffectiveDataType(YangType effectiveDataType) {
        this.effectiveDataType = effectiveDataType;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public YangPathArgType getPathType() {
        return this.pathType;
    }

    public void setPathType(YangPathArgType pathType) {
        this.pathType = pathType;
    }

    public List<YangAtomicPath> getAtomicPath() {
        return Collections.unmodifiableList(this.atomicPath);
    }

    public void setAtomicPath(List<YangAtomicPath> atomicPath) {
        this.atomicPath = atomicPath;
    }

    public YangRelativePath getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(YangRelativePath relativePath) {
        this.relativePath = relativePath;
    }

    public T getReferredLeafOrLeafList() {
        return this.referredLeafOrLeafList;
    }

    public void setReferredLeafOrLeafList(T targetExtendedInfo) {
        this.referredLeafOrLeafList = targetExtendedInfo;
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return Collections.unmodifiableList(this.ifFeatureList);
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        this.ifFeatureList.add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.LEAFREF_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    @Override
    public ResolvableStatus getResolvableStatus() {
        return this.resolvableStatus;
    }

    @Override
    public void setResolvableStatus(ResolvableStatus resolvableStatus) {
        this.resolvableStatus = resolvableStatus;
    }

    @Override
    public void setAppErrorInfo(YangAppErrorInfo yangAppErrorInfo) {
        this.yangAppErrorInfo = yangAppErrorInfo;
    }

    @Override
    public YangAppErrorInfo getAppErrorInfo() {
        return this.yangAppErrorInfo;
    }

    public Object resolve() throws DataModelException {
        if (this.getReferredLeafOrLeafList() == null) {
            throw new DataModelException("Linker Error: The leafref does not refer to any leaf/leaf-list. in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        try {
            this.setResolvableStatus(this.getResolution());
        }
        catch (DataModelException e) {
            throw new DataModelException(e.getMessage());
        }
        return null;
    }

    private ResolvableStatus getResolution() throws DataModelException {
        if (this.getReferredLeafOrLeafList() instanceof YangLeaf) {
            YangLeaf yangLeaf = (YangLeaf)this.getReferredLeafOrLeafList();
            YangType<?> baseType = yangLeaf.getDataType();
            if (baseType.getDataType() == YangDataTypes.LEAFREF) {
                YangLeafRef referredLeafRefInfo = (YangLeafRef)yangLeaf.getDataType().getDataTypeExtendedInfo();
                if (referredLeafRefInfo.getResolvableStatus() != ResolvableStatus.INTRA_FILE_RESOLVED && referredLeafRefInfo.getResolvableStatus() != ResolvableStatus.RESOLVED) {
                    throw new DataModelException("Linker Error: Referred typedef is not resolved for type. in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
                }
                if (referredLeafRefInfo.getResolvableStatus() == ResolvableStatus.INTRA_FILE_RESOLVED) {
                    return ResolvableStatus.INTRA_FILE_RESOLVED;
                }
                List<YangIfFeature> referredLeafIfFeatureListFromLeafref = referredLeafRefInfo.getIfFeatureList();
                if (referredLeafIfFeatureListFromLeafref != null && !referredLeafIfFeatureListFromLeafref.isEmpty()) {
                    for (YangIfFeature ifFeature : referredLeafIfFeatureListFromLeafref) {
                        this.addIfFeatureList(ifFeature);
                    }
                }
                this.setEffectiveDataType(referredLeafRefInfo.getEffectiveDataType());
            } else if (baseType.getDataType() == YangDataTypes.DERIVED) {
                if (baseType.getResolvableStatus() != ResolvableStatus.INTRA_FILE_RESOLVED && baseType.getResolvableStatus() != ResolvableStatus.RESOLVED) {
                    throw new DataModelException("Linker Error: Referred typedef is not resolved for type. in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
                }
                if (baseType.getResolvableStatus() == ResolvableStatus.INTRA_FILE_RESOLVED) {
                    return ResolvableStatus.INTRA_FILE_RESOLVED;
                }
                this.setEffectiveDataType(baseType);
            } else {
                this.setEffectiveDataType(baseType);
            }
            List<YangIfFeature> referredLeafIfFeatureList = yangLeaf.getIfFeatureList();
            if (referredLeafIfFeatureList != null && !referredLeafIfFeatureList.isEmpty()) {
                for (YangIfFeature ifFeature : referredLeafIfFeatureList) {
                    this.addIfFeatureList(ifFeature);
                }
            }
            return ResolvableStatus.RESOLVED;
        }
        if (this.getReferredLeafOrLeafList() instanceof YangLeafList) {
            YangLeafList yangLeafList = (YangLeafList)this.getReferredLeafOrLeafList();
            YangType<?> baseType = yangLeafList.getDataType();
            if (baseType.getDataType() == YangDataTypes.LEAFREF) {
                YangLeafRef referredLeafRefInfo = (YangLeafRef)yangLeafList.getDataType().getDataTypeExtendedInfo();
                if (referredLeafRefInfo.getResolvableStatus() != ResolvableStatus.INTRA_FILE_RESOLVED && referredLeafRefInfo.getResolvableStatus() != ResolvableStatus.RESOLVED) {
                    throw new DataModelException("Linker Error: Referred typedef is not resolved for type. in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
                }
                if (referredLeafRefInfo.getResolvableStatus() == ResolvableStatus.INTRA_FILE_RESOLVED) {
                    return ResolvableStatus.INTRA_FILE_RESOLVED;
                }
                List<YangIfFeature> referredLeafListIfFeatureListFromLeafref = referredLeafRefInfo.getIfFeatureList();
                if (referredLeafListIfFeatureListFromLeafref != null && !referredLeafListIfFeatureListFromLeafref.isEmpty()) {
                    for (YangIfFeature ifFeature : referredLeafListIfFeatureListFromLeafref) {
                        this.addIfFeatureList(ifFeature);
                    }
                }
                this.setEffectiveDataType(referredLeafRefInfo.getEffectiveDataType());
            } else if (baseType.getDataType() == YangDataTypes.DERIVED) {
                if (baseType.getResolvableStatus() != ResolvableStatus.INTRA_FILE_RESOLVED && baseType.getResolvableStatus() != ResolvableStatus.RESOLVED) {
                    throw new DataModelException("Linker Error: Referred typedef is not resolved for type. in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
                }
                if (baseType.getResolvableStatus() == ResolvableStatus.INTRA_FILE_RESOLVED) {
                    return ResolvableStatus.INTRA_FILE_RESOLVED;
                }
                this.setEffectiveDataType(baseType);
            } else {
                this.setEffectiveDataType(baseType);
            }
            List<YangIfFeature> referredLeafListIfFeatureList = yangLeafList.getIfFeatureList();
            if (referredLeafListIfFeatureList != null && !referredLeafListIfFeatureList.isEmpty()) {
                for (YangIfFeature ifFeature : referredLeafListIfFeatureList) {
                    this.addIfFeatureList(ifFeature);
                }
            }
            return ResolvableStatus.RESOLVED;
        }
        throw new DataModelException("Linker Error: The leafref must refer only to leaf/leaf-list. in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
    }

    public YangLeafRef<T> clone() throws CloneNotSupportedException {
        YangLeafRef clonedLeafRef = (YangLeafRef)super.clone();
        return clonedLeafRef;
    }

    public boolean isInGrouping() {
        return this.inGrouping;
    }

    public void setInGrouping(boolean inGrouping) {
        this.inGrouping = inGrouping;
    }
}

