/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.ResolvableType;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangBelongsTo;
import org.onosproject.yangutils.datamodel.YangDesc;
import org.onosproject.yangutils.datamodel.YangExtension;
import org.onosproject.yangutils.datamodel.YangFeature;
import org.onosproject.yangutils.datamodel.YangFeatureHolder;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangInclude;
import org.onosproject.yangutils.datamodel.YangIsFilterContentNodes;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangNamespace;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangReference;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.YangResolutionInfo;
import org.onosproject.yangutils.datamodel.YangRevision;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;

public abstract class YangSubModule
extends YangNode
implements YangLeavesHolder,
YangDesc,
YangReference,
Parsable,
CollisionDetector,
YangReferenceResolver,
RpcNotificationContainer,
YangFeatureHolder,
YangIsFilterContentNodes,
YangNamespace {
    private static final long serialVersionUID = 806201614L;
    private YangBelongsTo belongsTo;
    private String contact;
    private String description;
    private List<YangImport> importList;
    private List<YangInclude> includeList;
    private List<YangLeaf> listOfLeaf;
    private List<YangLeafList> listOfLeafList;
    private List<YangFeature> listOfFeature;
    private String organization;
    private String reference;
    private YangRevision revision;
    private byte version;
    private String prefix;
    private List<YangResolutionInfo> derivedTypeResolutionList = new LinkedList<YangResolutionInfo>();
    private List<YangResolutionInfo> usesResolutionList;
    private List<YangResolutionInfo> ifFeatureResolutionList;
    private List<YangResolutionInfo> leafRefResolutionList;
    private List<YangResolutionInfo> baseResolutionList;
    private List<YangResolutionInfo> identityRefResolutionList;
    private List<YangResolutionInfo> compilerAnnotationList;
    private List<YangExtension> extensionList;
    private List<YangResolutionInfo> augmentResolutionList = new LinkedList<YangResolutionInfo>();
    private boolean isNotificationPresent;
    private final Map<String, YangSchemaNode> notificationEnumMap;
    private final List<YangAugment> augments;
    private String namespace;

    public YangSubModule() {
        super(YangNodeType.SUB_MODULE_NODE, new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>());
        this.usesResolutionList = new LinkedList<YangResolutionInfo>();
        this.ifFeatureResolutionList = new LinkedList<YangResolutionInfo>();
        this.leafRefResolutionList = new LinkedList<YangResolutionInfo>();
        this.baseResolutionList = new LinkedList<YangResolutionInfo>();
        this.identityRefResolutionList = new LinkedList<YangResolutionInfo>();
        this.compilerAnnotationList = new LinkedList<YangResolutionInfo>();
        this.importList = new LinkedList<YangImport>();
        this.includeList = new LinkedList<YangInclude>();
        this.listOfLeaf = new LinkedList<YangLeaf>();
        this.listOfLeafList = new LinkedList<YangLeafList>();
        this.extensionList = new LinkedList<YangExtension>();
        this.compilerAnnotationList = new LinkedList<YangResolutionInfo>();
        this.listOfFeature = new LinkedList<YangFeature>();
        this.notificationEnumMap = new HashMap<String, YangSchemaNode>();
        this.augments = new LinkedList<YangAugment>();
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo context) {
        this.getYsnContextInfoMap().put(id, context);
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier id, YangSchemaNode yangSchemaNode) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_SINGLE_INSTANCE_NODE;
    }

    public YangBelongsTo getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(YangBelongsTo belongsTo) {
        this.belongsTo = belongsTo;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<YangImport> getImportList() {
        return Collections.unmodifiableList(this.importList);
    }

    @Override
    public void addToImportList(YangImport importedModule) {
        this.importList.add(importedModule);
    }

    @Override
    public void setImportList(List<YangImport> importList) {
        this.importList = importList;
    }

    @Override
    public List<YangInclude> getIncludeList() {
        return Collections.unmodifiableList(this.includeList);
    }

    @Override
    public void addToIncludeList(YangInclude includeModule) {
        this.includeList.add(includeModule);
    }

    @Override
    public void setIncludeList(List<YangInclude> includeList) {
        this.includeList = includeList;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void resolveSelfFileLinking(ResolvableType type) throws DataModelException {
        List<YangResolutionInfo> resolutionList = this.getUnresolvedResolutionList(type);
        DataModelUtils.resolveLinkingForResolutionList(resolutionList, this);
    }

    @Override
    public void resolveInterFileLinking(ResolvableType type) throws DataModelException {
        List<YangResolutionInfo> resolutionList = this.getUnresolvedResolutionList(type);
        DataModelUtils.linkInterFileReferences(resolutionList, this);
    }

    @Override
    public List<YangLeaf> getListOfLeaf() {
        return Collections.unmodifiableList(this.listOfLeaf);
    }

    @Override
    public void setListOfLeaf(List<YangLeaf> leafsList) {
        this.listOfLeaf = leafsList;
    }

    @Override
    public void addLeaf(YangLeaf leaf) {
        this.listOfLeaf.add(leaf);
    }

    @Override
    public List<YangLeafList> getListOfLeafList() {
        return Collections.unmodifiableList(this.listOfLeafList);
    }

    @Override
    public void setListOfLeafList(List<YangLeafList> listOfLeafList) {
        this.listOfLeafList = listOfLeafList;
    }

    @Override
    public void addLeafList(YangLeafList leafList) {
        this.listOfLeafList.add(leafList);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String org) {
        this.organization = org;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangRevision getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(YangRevision revision) {
        this.revision = revision;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.SUB_MODULE_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    @Override
    public void detectCollidingChild(String id, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(id, dataType, this);
    }

    @Override
    public void detectSelfCollision(String id, YangConstructType dataType) throws DataModelException {
    }

    @Override
    public List<YangResolutionInfo> getUnresolvedResolutionList(ResolvableType type) {
        if (type == ResolvableType.YANG_DERIVED_DATA_TYPE) {
            return Collections.unmodifiableList(this.derivedTypeResolutionList);
        }
        if (type == ResolvableType.YANG_USES) {
            return Collections.unmodifiableList(this.usesResolutionList);
        }
        if (type == ResolvableType.YANG_AUGMENT) {
            return Collections.unmodifiableList(this.augmentResolutionList);
        }
        if (type == ResolvableType.YANG_IF_FEATURE) {
            return Collections.unmodifiableList(this.ifFeatureResolutionList);
        }
        if (type == ResolvableType.YANG_LEAFREF) {
            return Collections.unmodifiableList(this.leafRefResolutionList);
        }
        if (type == ResolvableType.YANG_BASE) {
            return Collections.unmodifiableList(this.baseResolutionList);
        }
        if (type == ResolvableType.YANG_IDENTITYREF) {
            return Collections.unmodifiableList(this.identityRefResolutionList);
        }
        return Collections.unmodifiableList(this.compilerAnnotationList);
    }

    @Override
    public void addToResolutionList(YangResolutionInfo resolutionInfo, ResolvableType type) {
        if (type == ResolvableType.YANG_DERIVED_DATA_TYPE) {
            this.derivedTypeResolutionList.add(resolutionInfo);
        } else if (type == ResolvableType.YANG_USES) {
            this.usesResolutionList.add(resolutionInfo);
        } else if (type == ResolvableType.YANG_IF_FEATURE) {
            this.ifFeatureResolutionList.add(resolutionInfo);
        } else if (type == ResolvableType.YANG_LEAFREF) {
            this.leafRefResolutionList.add(resolutionInfo);
        } else if (type == ResolvableType.YANG_BASE) {
            this.baseResolutionList.add(resolutionInfo);
        } else if (type == ResolvableType.YANG_AUGMENT) {
            this.augmentResolutionList.add(resolutionInfo);
        } else if (type == ResolvableType.YANG_IDENTITYREF) {
            this.identityRefResolutionList.add(resolutionInfo);
        } else if (type == ResolvableType.YANG_COMPILER_ANNOTATION) {
            this.compilerAnnotationList.add(resolutionInfo);
        }
    }

    @Override
    public void setResolutionList(List<YangResolutionInfo> resolutionList, ResolvableType type) {
        if (type == ResolvableType.YANG_DERIVED_DATA_TYPE) {
            this.derivedTypeResolutionList = resolutionList;
        } else if (type == ResolvableType.YANG_USES) {
            this.usesResolutionList = resolutionList;
        } else if (type == ResolvableType.YANG_IF_FEATURE) {
            this.ifFeatureResolutionList.add((YangResolutionInfo)((Object)resolutionList));
        } else if (type == ResolvableType.YANG_LEAFREF) {
            this.leafRefResolutionList = resolutionList;
        } else if (type == ResolvableType.YANG_BASE) {
            this.baseResolutionList = resolutionList;
        } else if (type == ResolvableType.YANG_AUGMENT) {
            this.augmentResolutionList = resolutionList;
        } else if (type == ResolvableType.YANG_IDENTITYREF) {
            this.identityRefResolutionList = resolutionList;
        } else if (type == ResolvableType.YANG_COMPILER_ANNOTATION) {
            this.compilerAnnotationList = resolutionList;
        }
    }

    public void linkWithModule(Set<YangNode> yangNodeSet) throws DataModelException {
        this.belongsTo.linkWithModule(yangNodeSet);
        this.namespace = ((YangNamespace)((Object)this.belongsTo.getModuleNode())).getModuleNamespace();
    }

    @Override
    public void addReferencesToIncludeList(Set<YangNode> yangNodeSet) throws DataModelException {
        for (YangInclude yangInclude : this.getIncludeList()) {
            YangSubModule subModule = yangInclude.addReferenceToInclude(yangNodeSet);
            if (Objects.equals(subModule.getBelongsTo().getModuleNode(), this.getBelongsTo().getModuleNode())) continue;
            yangInclude.reportIncludeError();
        }
    }

    @Override
    public void addReferencesToImportList(Set<YangNode> yangNodeSet) throws DataModelException {
        for (YangImport yangImport : this.getImportList()) {
            yangImport.addReferenceToImport(yangNodeSet);
        }
    }

    @Override
    public List<YangFeature> getFeatureList() {
        return Collections.unmodifiableList(this.listOfFeature);
    }

    @Override
    public void addFeatureList(YangFeature feature) {
        this.listOfFeature.add(feature);
    }

    @Override
    public void setListOfFeature(List<YangFeature> listOfFeature) {
        this.listOfFeature = listOfFeature;
    }

    public void addExtension(YangExtension extension) {
        this.extensionList.add(extension);
    }

    public List<YangExtension> getExtensionList() {
        return Collections.unmodifiableList(this.extensionList);
    }

    public void setExtensionList(List<YangExtension> extensionList) {
        this.extensionList = extensionList;
    }

    @Override
    public void setLeafNameSpaceAndAddToParentSchemaMap() {
        for (YangLeaf yangLeaf : this.getListOfLeaf()) {
            yangLeaf.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
        for (YangLeafList yangLeafList : this.getListOfLeafList()) {
            yangLeafList.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
    }

    @Override
    public boolean isNotificationPresent() {
        return this.isNotificationPresent;
    }

    @Override
    public void setNotificationPresenceFlag(boolean notificationPresent) {
        this.isNotificationPresent = notificationPresent;
    }

    @Override
    public void addToNotificationEnumMap(String enumName, YangSchemaNode notification) {
        this.notificationEnumMap.put(enumName, notification);
    }

    @Override
    public YangSchemaNode getNotificationSchemaNode(String enumName) {
        return this.notificationEnumMap.get(enumName);
    }

    @Override
    public void addToAugmentList(YangAugment augment) {
        this.augments.add(augment);
    }

    @Override
    public List<YangAugment> getAugmentList() {
        return Collections.unmodifiableList(this.augments);
    }

    @Override
    public String getModuleNamespace() {
        return this.namespace;
    }

    @Override
    public String getModuleName() {
        return this.getName();
    }

    public void setModuleNamespace(String namespace) {
        this.namespace = namespace;
    }
}

