/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.LeafRefInvalidHolder;
import org.onosproject.yangutils.datamodel.Resolvable;
import org.onosproject.yangutils.datamodel.TraversalType;
import org.onosproject.yangutils.datamodel.YangCommonInfo;
import org.onosproject.yangutils.datamodel.YangEntityToResolveInfoImpl;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangIfFeature;
import org.onosproject.yangutils.datamodel.YangIfFeatureHolder;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangStatusType;
import org.onosproject.yangutils.datamodel.YangTranslatorOperatorNode;
import org.onosproject.yangutils.datamodel.YangWhen;
import org.onosproject.yangutils.datamodel.YangWhenHolder;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.exceptions.ErrorMessages;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;

public abstract class YangUses
extends YangNode
implements YangCommonInfo,
Parsable,
Resolvable,
CollisionDetector,
YangWhenHolder,
YangIfFeatureHolder,
YangTranslatorOperatorNode,
LeafRefInvalidHolder {
    private static final long serialVersionUID = 806201617L;
    private YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
    private YangGrouping refGroup;
    private String description;
    private String reference;
    private YangStatusType status;
    private YangWhen when;
    private List<YangIfFeature> ifFeatureList;
    private ResolvableStatus resolvableStatus = ResolvableStatus.UNRESOLVED;
    private List<YangEntityToResolveInfoImpl> entityToResolveInfoList;
    private int currentGroupingDepth;

    public YangUses() {
        super(YangNodeType.USES_NODE, null);
        this.ifFeatureList = new LinkedList<YangIfFeature>();
        this.entityToResolveInfoList = new LinkedList<YangEntityToResolveInfoImpl>();
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo context) throws DataModelException {
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier id, YangSchemaNode yangSchemaNode) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_NON_DATA_NODE;
    }

    public void addEntityToResolve(List<YangEntityToResolveInfoImpl> entityToResolve) throws DataModelException {
        if (this.entityToResolveInfoList == null) {
            this.entityToResolveInfoList = new LinkedList<YangEntityToResolveInfoImpl>();
        }
        this.entityToResolveInfoList.addAll(entityToResolve);
    }

    public YangGrouping getRefGroup() {
        return this.refGroup;
    }

    public void setRefGroup(YangGrouping refGroup) {
        this.refGroup = refGroup;
    }

    @Override
    public YangWhen getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(YangWhen when) {
        this.when = when;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.USES_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    public YangNodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(YangNodeIdentifier nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public String getPrefix() {
        return this.nodeIdentifier.getPrefix();
    }

    public void setPrefix(String prefix) {
        this.nodeIdentifier.setPrefix(prefix);
    }

    public Object resolve() throws DataModelException {
        YangGrouping referredGrouping = this.getRefGroup();
        if (referredGrouping == null) {
            throw new DataModelException("YANG uses linker error, cannot resolve uses " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (this.checkIsUnresolvedRecursiveUsesInGrouping(referredGrouping)) {
            return null;
        }
        YangNode usesParentNode = DataModelUtils.getParentNodeInGenCode(this);
        if (!(usesParentNode instanceof YangLeavesHolder) || !(usesParentNode instanceof CollisionDetector)) {
            throw new DataModelException("YANG uses holder construct is wrong " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        YangLeavesHolder usesParent = (YangLeavesHolder)((Object)usesParentNode);
        if (referredGrouping.getListOfLeaf() != null) {
            for (YangLeaf leaf : referredGrouping.getListOfLeaf()) {
                YangLeaf clonedLeaf;
                try {
                    ((CollisionDetector)((Object)usesParent)).detectCollidingChild(leaf.getName(), YangConstructType.LEAF_DATA);
                    clonedLeaf = leaf.clone();
                    clonedLeaf.setReferredLeaf(leaf);
                    DataModelUtils.addUnresolvedType(this, clonedLeaf, (YangNode)((Object)usesParent));
                }
                catch (CloneNotSupportedException | DataModelException e) {
                    throw new DataModelException(e.getMessage());
                }
                clonedLeaf.setContainedIn(usesParent);
                usesParent.addLeaf(clonedLeaf);
            }
        }
        if (referredGrouping.getListOfLeafList() != null) {
            for (YangLeafList leafList : referredGrouping.getListOfLeafList()) {
                YangLeafList clonedLeafList;
                try {
                    ((CollisionDetector)((Object)usesParent)).detectCollidingChild(leafList.getName(), YangConstructType.LEAF_LIST_DATA);
                    clonedLeafList = leafList.clone();
                    clonedLeafList.setReferredSchemaLeafList(leafList);
                    DataModelUtils.addUnresolvedType(this, clonedLeafList, (YangNode)((Object)usesParent));
                }
                catch (CloneNotSupportedException | DataModelException e) {
                    throw new DataModelException(e.getMessage());
                }
                clonedLeafList.setContainedIn(usesParent);
                usesParent.addLeafList(clonedLeafList);
            }
        }
        try {
            YangNode.cloneSubTree(referredGrouping, usesParentNode, this);
        }
        catch (DataModelException e) {
            throw new DataModelException(e.getMessage());
        }
        DataModelUtils.updateClonedLeavesUnionEnumRef(usesParent);
        return Collections.unmodifiableList(this.entityToResolveInfoList);
    }

    private boolean checkIsUnresolvedRecursiveUsesInGrouping(YangGrouping referredGrouping) {
        TraversalType curTraversal = TraversalType.ROOT;
        YangNode curNode = referredGrouping.getChild();
        while (curNode != null) {
            if (curNode == referredGrouping || curNode instanceof YangUses && curNode.getName().equals(referredGrouping.getName())) {
                return false;
            }
            if (curNode instanceof YangUses && ((YangUses)curNode).getResolvableStatus() != ResolvableStatus.RESOLVED) {
                this.setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
                return true;
            }
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                curNode = curNode.getChild();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                curTraversal = TraversalType.SIBILING;
                curNode = curNode.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            curNode = curNode.getParent();
        }
        return false;
    }

    @Override
    public ResolvableStatus getResolvableStatus() {
        return this.resolvableStatus;
    }

    @Override
    public void setResolvableStatus(ResolvableStatus resolvableStatus) {
        this.resolvableStatus = resolvableStatus;
    }

    @Override
    public void detectCollidingChild(String identifierName, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(identifierName, dataType, this);
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (this.getName().equals(identifierName)) {
            throw new DataModelException(ErrorMessages.getErrorMsgCollision("YANG File Error: Identifier collision detected in", this.getName(), this.getLineNumber(), this.getCharPosition(), " uses ", this.getFileName()));
        }
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return Collections.unmodifiableList(this.ifFeatureList);
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        if (this.ifFeatureList == null) {
            this.ifFeatureList = new LinkedList<YangIfFeature>();
        }
        this.ifFeatureList.add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    public void setCurrentGroupingDepth(int currentGroupingDepth) {
        this.currentGroupingDepth = currentGroupingDepth;
    }

    public int getCurrentGroupingDepth() {
        return this.currentGroupingDepth;
    }

    @Override
    public String getName() {
        return this.nodeIdentifier.getName();
    }

    @Override
    public void setName(String name) {
        this.nodeIdentifier.setName(name);
    }

    @Override
    public YangNode clone(YangUses node) throws CloneNotSupportedException {
        YangNode clnNode = (YangNode)super.clone();
        clnNode.setParent(null);
        clnNode.setChild(null);
        clnNode.setNextSibling(null);
        clnNode.setPreviousSibling(null);
        return clnNode;
    }
}

