/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.ResolvableType;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangBase;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangEntityToResolveInfoImpl;
import org.onosproject.yangutils.datamodel.YangEnumeration;
import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangIfFeature;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.YangResolutionInfo;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangUnion;
import org.onosproject.yangutils.datamodel.YangUses;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;

public final class DataModelUtils {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final String SLASH = File.separator;

    private DataModelUtils() {
    }

    public static void detectCollidingChildUtil(String identifierName, YangConstructType dataType, YangNode node) throws DataModelException {
        if (dataType == YangConstructType.USES_DATA || dataType == YangConstructType.GROUPING_DATA) {
            DataModelUtils.detectCollidingForUsesGrouping(identifierName, dataType, node);
        } else {
            if (node instanceof YangLeavesHolder) {
                YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)node);
                DataModelUtils.detectCollidingLeaf(leavesHolder.getListOfLeaf(), identifierName);
                DataModelUtils.detectCollidingLeafList(leavesHolder.getListOfLeafList(), identifierName);
            }
            for (node = node.getChild(); node != null; node = node.getNextSibling()) {
                Parsable parsable = (Parsable)((Object)node);
                if (!(node instanceof CollisionDetector) || parsable.getYangConstructType() == YangConstructType.USES_DATA || parsable.getYangConstructType() == YangConstructType.GROUPING_DATA) continue;
                ((CollisionDetector)((Object)node)).detectSelfCollision(identifierName, dataType);
            }
        }
    }

    private static void detectCollidingForUsesGrouping(String identifierName, YangConstructType dataType, YangNode node) throws DataModelException {
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            Parsable parsable = (Parsable)((Object)node);
            if (!(node instanceof CollisionDetector) || parsable.getYangConstructType() != dataType) continue;
            ((CollisionDetector)((Object)node)).detectSelfCollision(identifierName, dataType);
        }
    }

    private static void detectCollidingLeaf(List<YangLeaf> listOfLeaf, String identifierName) throws DataModelException {
        if (listOfLeaf == null) {
            return;
        }
        for (YangLeaf leaf : listOfLeaf) {
            if (!leaf.getName().equals(identifierName)) continue;
            throw new DataModelException("YANG file error: Duplicate input identifier detected, same as leaf \"" + leaf.getName() + " in " + leaf.getLineNumber() + " at " + leaf.getCharPosition() + " in " + leaf.getFileName() + "\"");
        }
    }

    private static void detectCollidingLeafList(List<YangLeafList> listOfLeafList, String identifierName) throws DataModelException {
        if (listOfLeafList == null) {
            return;
        }
        for (YangLeafList leafList : listOfLeafList) {
            if (!leafList.getName().equals(identifierName)) continue;
            throw new DataModelException("YANG file error: Duplicate input identifier detected, same as leaf list \"" + leafList.getName() + " in " + leafList.getLineNumber() + " at " + leafList.getCharPosition() + " in " + leafList.getFileName() + "\"");
        }
    }

    public static void addResolutionInfo(YangResolutionInfo resolutionInfo) throws DataModelException {
        YangNode curNode = resolutionInfo.getEntityToResolveInfo().getHolderOfEntityToResolve();
        while (!(curNode instanceof YangReferenceResolver)) {
            if ((curNode = curNode.getParent()) != null) continue;
            throw new DataModelException("Internal datamodel error: Datamodel tree is not correct");
        }
        YangReferenceResolver resolutionNode = (YangReferenceResolver)((Object)curNode);
        if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangType) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_DERIVED_DATA_TYPE);
        } else if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangUses) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_USES);
        } else if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangAugment) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_AUGMENT);
        } else if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangIfFeature) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_IF_FEATURE);
        } else if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangLeafRef) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_LEAFREF);
        } else if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangBase) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_BASE);
        } else if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangIdentityRef) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_IDENTITYREF);
        } else if (resolutionInfo.getEntityToResolveInfo().getEntityToResolve() instanceof YangCompilerAnnotation) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_COMPILER_ANNOTATION);
        }
    }

    public static void resolveLinkingForResolutionList(List<YangResolutionInfo> resolutionList, YangReferenceResolver dataModelRootNode) throws DataModelException {
        for (YangResolutionInfo resolutionInfo : resolutionList) {
            resolutionInfo.resolveLinkingForResolutionInfo(dataModelRootNode);
        }
    }

    public static void linkInterFileReferences(List<YangResolutionInfo> resolutionList, YangReferenceResolver dataModelRootNode) throws DataModelException {
        if (resolutionList != null) {
            for (YangResolutionInfo resolutionInfo : resolutionList) {
                resolutionInfo.linkInterFile(dataModelRootNode);
            }
        }
    }

    public static boolean isRpcChildNodePresent(YangNode rootNode) {
        for (YangNode childNode = rootNode.getChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!(childNode instanceof YangRpc)) continue;
            return true;
        }
        return false;
    }

    public static YangNode findReferredNode(Set<YangNode> yangNodeSet, String refNodeName) {
        for (YangNode yangNode : yangNodeSet) {
            if (!yangNode.getName().equals(refNodeName)) continue;
            return yangNode;
        }
        return null;
    }

    public static YangNode getParentNodeInGenCode(YangNode currentNode) {
        return currentNode.getParent();
    }

    public static Set<YangNode> deSerializeDataModel(String serializedFileInfo) throws IOException {
        Set nodes;
        try {
            FileInputStream fileInputStream = new FileInputStream(serializedFileInfo);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            nodes = (Set)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IOException(serializedFileInfo + " not found.");
        }
        return nodes;
    }

    public static void cloneListOfLeaf(YangLeavesHolder clonedNode, YangUses yangUses) throws CloneNotSupportedException, DataModelException {
        List<YangLeaf> leaves = clonedNode.getListOfLeaf();
        if (DataModelUtils.nonEmpty(leaves)) {
            LinkedList<YangLeaf> clonedLeaves = new LinkedList<YangLeaf>();
            for (YangLeaf leaf : leaves) {
                YangLeaf clonedLeaf = leaf.clone();
                clonedLeaf.setReferredLeaf(leaf);
                DataModelUtils.addUnresolvedType(yangUses, clonedLeaf, (YangNode)((Object)clonedNode));
                clonedLeaf.setContainedIn(clonedNode);
                clonedLeaves.add(clonedLeaf);
            }
            clonedNode.setListOfLeaf(clonedLeaves);
        }
    }

    public static void addUnresolvedType(YangUses yangUses, Object clonedObj, YangNode clonedNode) throws DataModelException {
        List<YangEntityToResolveInfoImpl> infoList;
        if (yangUses != null && yangUses.getCurrentGroupingDepth() == 0 && DataModelUtils.nonEmpty(infoList = DataModelUtils.getTypesToBeResolved(clonedObj, clonedNode, yangUses))) {
            yangUses.addEntityToResolve(infoList);
        }
    }

    public static boolean nonEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    public static void cloneListOfLeafList(YangLeavesHolder clonedNode, YangUses yangUses) throws CloneNotSupportedException, DataModelException {
        List<YangLeafList> listOfLeafList = clonedNode.getListOfLeafList();
        if (DataModelUtils.nonEmpty(listOfLeafList)) {
            LinkedList<YangLeafList> clonedList = new LinkedList<YangLeafList>();
            for (YangLeafList leafList : listOfLeafList) {
                YangLeafList clonedLeafList = leafList.clone();
                clonedLeafList.setReferredSchemaLeafList(leafList);
                DataModelUtils.addUnresolvedType(yangUses, clonedLeafList, (YangNode)((Object)clonedNode));
                clonedLeafList.setContainedIn(clonedNode);
                clonedList.add(clonedLeafList);
            }
            clonedNode.setListOfLeafList(clonedList);
        }
    }

    private static List<YangEntityToResolveInfoImpl> getTypesToBeResolved(Object clonedObj, YangNode holderNode, YangUses yangUses) throws DataModelException {
        if (clonedObj instanceof YangLeaf) {
            YangLeaf clonedLeaf = (YangLeaf)clonedObj;
            YangType<?> type = clonedLeaf.getDataType();
            return DataModelUtils.getUnresolvedTypeList(type.getDataType(), type, holderNode, yangUses, true);
        }
        YangLeafList clonedLeafList = (YangLeafList)clonedObj;
        YangType<?> type = clonedLeafList.getDataType();
        return DataModelUtils.getUnresolvedTypeList(type.getDataType(), type, holderNode, yangUses, false);
    }

    private static List<YangEntityToResolveInfoImpl> getUnresolvedTypeList(YangDataTypes dataTypes, YangType type, YangNode holder, YangUses yangUses, boolean isLeaf) throws DataModelException {
        ArrayList<YangEntityToResolveInfoImpl> infoList = new ArrayList<YangEntityToResolveInfoImpl>();
        YangEntityToResolveInfoImpl entity = null;
        List<YangEntityToResolveInfoImpl> entityList = null;
        switch (dataTypes) {
            case LEAFREF: {
                entity = DataModelUtils.getLeafRefResolvableEntity(type, yangUses, holder);
                break;
            }
            case DERIVED: {
                entity = DataModelUtils.getDerivedResolvableEntity(type, holder, isLeaf);
                break;
            }
            case UNION: {
                entityList = DataModelUtils.getUnionResolvableEntity(type, isLeaf);
                break;
            }
            default: {
                return null;
            }
        }
        infoList.add(entity);
        if (DataModelUtils.nonEmpty(entityList)) {
            infoList.addAll(entityList);
        }
        return infoList;
    }

    private static YangEntityToResolveInfoImpl getLeafRefResolvableEntity(YangType type, YangUses yangUses, YangNode holder) throws DataModelException {
        YangEntityToResolveInfoImpl<YangLeafRef> leafRefInfo = new YangEntityToResolveInfoImpl<YangLeafRef>();
        YangLeafRef leafRef = (YangLeafRef)type.getDataTypeExtendedInfo();
        DataModelUtils.convertThePrefixesDuringChange(leafRef, yangUses);
        leafRef.setParentNode(holder);
        leafRefInfo.setEntityToResolve(leafRef);
        return DataModelUtils.setInformationInEntity(leafRefInfo, holder, leafRef.getCharPosition(), leafRef.getLineNumber());
    }

    private static YangEntityToResolveInfoImpl getDerivedResolvableEntity(YangType<?> type, YangNode holder, boolean isLeaf) {
        YangEntityToResolveInfoImpl derivedInfo = new YangEntityToResolveInfoImpl();
        if (type.isTypeForInterFileGroupingResolution()) {
            return null;
        }
        if (!isLeaf && type.isTypeNotResolvedTillRootNode()) {
            return null;
        }
        derivedInfo.setEntityToResolve(type);
        return DataModelUtils.setInformationInEntity(derivedInfo, holder, type.getCharPosition(), type.getLineNumber());
    }

    private static YangEntityToResolveInfoImpl<?> setInformationInEntity(YangEntityToResolveInfoImpl<?> entity, YangNode holder, int charPos, int lineNum) {
        entity.setHolderOfEntityToResolve(holder);
        entity.setCharPosition(charPos);
        entity.setLineNumber(lineNum);
        return entity;
    }

    private static List<YangEntityToResolveInfoImpl> getUnionResolvableEntity(YangType type, boolean isLeaf) throws DataModelException {
        YangUnion union = (YangUnion)type.getDataTypeExtendedInfo();
        List<YangType<?>> typeList = union.getTypeList();
        ArrayList<YangEntityToResolveInfoImpl> unionList = new ArrayList<YangEntityToResolveInfoImpl>();
        for (YangType<?> unionType : typeList) {
            List<YangEntityToResolveInfoImpl> entity = DataModelUtils.getUnresolvedTypeList(unionType.getDataType(), unionType, union, null, isLeaf);
            if (!DataModelUtils.nonEmpty(entity)) continue;
            unionList.addAll(entity);
        }
        return unionList;
    }

    private static void convertThePrefixesDuringChange(YangLeafRef leafrefForCloning, YangUses yangUses) throws DataModelException {
        List<YangAtomicPath> atomicPathList = leafrefForCloning.getAtomicPath();
        if (atomicPathList != null && !atomicPathList.isEmpty()) {
            ListIterator<YangAtomicPath> atomicPathIterator = atomicPathList.listIterator();
            while (atomicPathIterator.hasNext()) {
                YangAtomicPath atomicPath = (YangAtomicPath)atomicPathIterator.next();
                Map<String, String> prefixesAndItsImportNameNode = leafrefForCloning.getPrefixAndNode();
                String prefixInPath = atomicPath.getNodeIdentifier().getPrefix();
                String importedNodeName = prefixesAndItsImportNameNode.get(prefixInPath);
                DataModelUtils.assignCurrentLeafedWithNewPrefixes(importedNodeName, atomicPath, yangUses);
            }
        }
    }

    private static void assignCurrentLeafedWithNewPrefixes(String importedNodeName, YangAtomicPath atomicPath, YangNode node) throws DataModelException {
        List<YangImport> importInUsesList;
        while (!(node instanceof YangReferenceResolver)) {
            if ((node = node.getParent()) != null) continue;
            throw new DataModelException("Internal datamodel error: Datamodel tree is not correct");
        }
        if (node instanceof YangModule && (importInUsesList = ((YangModule)node).getImportList()) != null && !importInUsesList.isEmpty()) {
            ListIterator<YangImport> importInUsesListIterator = importInUsesList.listIterator();
            while (importInUsesListIterator.hasNext()) {
                YangImport importInUsesNode = (YangImport)importInUsesListIterator.next();
                if (!importInUsesNode.getModuleName().equals(importedNodeName)) continue;
                atomicPath.getNodeIdentifier().setPrefix(importInUsesNode.getPrefixId());
            }
        }
    }

    public static void updateClonedLeavesUnionEnumRef(YangLeavesHolder leavesHolder) throws DataModelException {
        List<YangLeafList> currentListOfLeafList;
        List<YangLeaf> currentListOfLeaves = leavesHolder.getListOfLeaf();
        if (currentListOfLeaves != null) {
            for (YangLeaf leaf : currentListOfLeaves) {
                if (leaf.getDataType().getDataType() != YangDataTypes.ENUMERATION && leaf.getDataType().getDataType() != YangDataTypes.UNION) continue;
                try {
                    Object clonedType = leaf.getDataType().clone();
                    DataModelUtils.updateClonedTypeRef((YangType)clonedType, leavesHolder);
                    leaf.setDataType((YangType<?>)clonedType);
                }
                catch (DataModelException e) {
                    throw e;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    throw new DataModelException("Could not clone Type node " + leaf.getDataType().getDataTypeName() + " in " + leaf.getDataType().getLineNumber() + " at " + leaf.getDataType().getCharPosition() + " in " + leaf.getDataType().getFileName() + "\"");
                }
            }
        }
        if ((currentListOfLeafList = leavesHolder.getListOfLeafList()) != null) {
            for (YangLeafList leafList : currentListOfLeafList) {
                if (leafList.getDataType().getDataType() != YangDataTypes.ENUMERATION && leafList.getDataType().getDataType() != YangDataTypes.UNION) continue;
                try {
                    Object clonedType = leafList.getDataType().clone();
                    DataModelUtils.updateClonedTypeRef((YangType)clonedType, leavesHolder);
                    leafList.setDataType((YangType<?>)clonedType);
                }
                catch (DataModelException e) {
                    throw e;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    throw new DataModelException("Could not clone Type node " + leafList.getDataType().getDataTypeName() + " in " + leafList.getDataType().getLineNumber() + " at " + leafList.getDataType().getCharPosition() + " in " + leafList.getDataType().getFileName() + "\"");
                }
            }
        }
    }

    private static void updateClonedTypeRef(YangType dataType, YangLeavesHolder leavesHolder) throws DataModelException {
        if (!(leavesHolder instanceof YangNode)) {
            throw new DataModelException("Data model error: cloned leaves holder is not a node  in " + leavesHolder.getLineNumber() + " at " + leavesHolder.getCharPosition() + " in " + leavesHolder.getFileName() + "\"");
        }
        for (YangNode potentialTypeNode = ((YangNode)((Object)leavesHolder)).getChild(); potentialTypeNode != null; potentialTypeNode = potentialTypeNode.getNextSibling()) {
            String dataTypeName = null;
            if (dataType.getDataType() == YangDataTypes.ENUMERATION) {
                YangEnumeration enumNode = (YangEnumeration)dataType.getDataTypeExtendedInfo();
                dataTypeName = enumNode.getName();
            } else if (dataType.getDataType() == YangDataTypes.UNION) {
                YangUnion unionNode = (YangUnion)dataType.getDataTypeExtendedInfo();
                dataTypeName = unionNode.getName();
            }
            if (!potentialTypeNode.getName().contentEquals(dataTypeName)) continue;
            dataType.setDataTypeExtendedInfo(potentialTypeNode);
            return;
        }
        throw new DataModelException("Data model error: cloned leaves type is not found " + dataType.getDataTypeName() + " in " + dataType.getLineNumber() + " at " + dataType.getCharPosition() + " in " + dataType.getFileName() + "\"");
    }

    public static List<YangNode> parseJarFile(String jarFile, String directory) throws IOException {
        ArrayList<YangNode> nodes = new ArrayList<YangNode>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            if (!file.getName().endsWith(".ser")) continue;
            if (file.getName().contains(SLASH)) {
                String[] strArray = file.getName().split(SLASH);
                String tempPath = "";
                for (int i = 0; i < strArray.length - 1; ++i) {
                    tempPath = SLASH + tempPath + SLASH + strArray[i];
                }
                File dir = new File(directory + tempPath);
                dir.mkdirs();
            }
            File serializedFile = new File(directory + SLASH + file.getName());
            if (file.isDirectory()) {
                serializedFile.mkdirs();
                continue;
            }
            InputStream inputStream = jar.getInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(serializedFile);
            while (inputStream.available() > 0) {
                fileOutputStream.write(inputStream.read());
            }
            fileOutputStream.close();
            inputStream.close();
            nodes.addAll(DataModelUtils.deSerializeDataModel(serializedFile.toString()));
        }
        jar.close();
        return nodes;
    }

    public static boolean validateEmptyDataType(YangType dataType) {
        switch (dataType.getDataType()) {
            case DERIVED: {
                return ((YangDerivedInfo)dataType.getDataTypeExtendedInfo()).getEffectiveBuiltInType().equals((Object)YangDataTypes.EMPTY);
            }
            case LEAFREF: {
                YangType type = ((YangLeafRef)dataType.getDataTypeExtendedInfo()).getEffectiveDataType();
                if (type.getDataType() == YangDataTypes.DERIVED) {
                    return ((YangDerivedInfo)type.getDataTypeExtendedInfo()).getEffectiveBuiltInType().equals((Object)YangDataTypes.EMPTY);
                }
                return ((YangLeafRef)dataType.getDataTypeExtendedInfo()).getEffectiveDataType().getDataType().equals((Object)YangDataTypes.EMPTY);
            }
            case UNION: {
                return ((YangUnion)dataType.getDataTypeExtendedInfo()).getTypeList().contains((Object)YangDataTypes.EMPTY);
            }
        }
        return dataType.getDataType().equals((Object)YangDataTypes.EMPTY);
    }
}

