/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangBase;
import org.onosproject.yangutils.datamodel.YangIdentity;
import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class BaseListener {
    private BaseListener() {
    }

    public static void processBaseEntry(TreeWalkListener listener, GeneratedYangParser.BaseStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BASE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        YangNodeIdentifier nodeIdentifier = ListenerUtil.getValidNodeIdentifier(ctx.string().getText(), YangConstructType.BASE_DATA, ctx);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData instanceof YangIdentityRef) {
            return;
        }
        if (!(tmpData instanceof YangIdentity)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.BASE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangBase yangBase = new YangBase();
        yangBase.setBaseIdentifier(nodeIdentifier);
        ((YangIdentity)tmpData).setBaseNode(yangBase);
        int errorLine = ctx.getStart().getLine();
        int errorPosition = ctx.getStart().getCharPositionInLine();
        yangBase.setLineNumber(errorLine);
        yangBase.setCharPosition(errorPosition);
        yangBase.setFileName(listener.getFileName());
        YangResolutionInfoImpl<YangBase> resolutionInfo = new YangResolutionInfoImpl<YangBase>(yangBase, (YangNode)((Object)tmpData), errorLine, errorPosition);
        BaseListener.addToResolutionList(resolutionInfo, ctx);
    }

    private static void addToResolutionList(YangResolutionInfoImpl<YangBase> resolutionInfo, GeneratedYangParser.BaseStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.BASE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
        }
    }
}

