/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangFeature;
import org.onosproject.yangutils.datamodel.YangFeatureHolder;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class FeatureListener {
    private FeatureListener() {
    }

    public static void processFeatureEntry(TreeWalkListener listener, GeneratedYangParser.FeatureStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.FEATURE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.string().getText(), YangConstructType.FEATURE_DATA, ctx);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangFeatureHolder)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.FEATURE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangFeatureHolder featureHolder = (YangFeatureHolder)((Object)tmpNode);
        YangFeature feature = new YangFeature();
        feature.setName(identifier);
        feature.setLineNumber(ctx.getStart().getLine());
        feature.setCharPosition(ctx.getStart().getCharPositionInLine());
        feature.setFileName(listener.getFileName());
        featureHolder.addFeatureList(feature);
        listener.getParsedDataStack().push(feature);
    }

    public static void processFeatureExit(TreeWalkListener listener, GeneratedYangParser.FeatureStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.FEATURE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangFeature)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.FEATURE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

