/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangContainer;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class GroupingListener {
    private GroupingListener() {
    }

    public static void processGroupingEntry(TreeWalkListener listener, GeneratedYangParser.GroupingStatementContext ctx) {
        YangGrouping groupingNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.GROUPING_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.GROUPING_DATA, ctx);
        GroupingListener.validateSubStatementsCardinality(ctx);
        listener.increaseGroupingDepth();
        Parsable curData = listener.getParsedDataStack().peek();
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.GROUPING_DATA);
        if (curData instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangContainer || curData instanceof YangNotification || curData instanceof YangList || curData instanceof YangGrouping || curData instanceof YangRpc || curData instanceof YangInput || curData instanceof YangOutput) {
            groupingNode = YangDataModelFactory.getYangGroupingNode(GeneratedLanguage.JAVA_GENERATION);
            groupingNode.setName(identifier);
            groupingNode.setGroupingDepth(listener.getGroupingDepth());
            groupingNode.setLineNumber(line);
            groupingNode.setCharPosition(charPositionInLine);
            groupingNode.setFileName(listener.getFileName());
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(groupingNode);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.GROUPING_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.GROUPING_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(groupingNode);
    }

    public static void processGroupingExit(TreeWalkListener listener, GeneratedYangParser.GroupingStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.GROUPING_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        listener.decreaseGroupingDepth();
        if (!(listener.getParsedDataStack().peek() instanceof YangGrouping)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.GROUPING_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.GroupingStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.GROUPING_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.GROUPING_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.GROUPING_DATA, ctx.identifier().getText());
    }
}

