/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class IdentityRefListener {
    private IdentityRefListener() {
    }

    public static void processIdentityRefEntry(TreeWalkListener listener, GeneratedYangParser.IdentityrefSpecificationContext ctx) {
        Parsable parentNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.IDENTITYREF_DATA, "", ListenerErrorLocation.ENTRY);
        if (!(listener.getParsedDataStack().peek() instanceof YangType)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, "", ListenerErrorLocation.ENTRY));
        }
        YangIdentityRef idRef = new YangIdentityRef();
        Parsable typeData = listener.getParsedDataStack().pop();
        YangNodeIdentifier nodeId = ListenerUtil.getValidNodeIdentifier(ctx.baseStatement().string().getText(), YangConstructType.BASE_DATA, ctx);
        idRef.setBaseIdentity(nodeId);
        ((YangType)typeData).setDataTypeExtendedInfo(idRef);
        int errLine = ctx.getStart().getLine();
        int errPos = ctx.getStart().getCharPositionInLine();
        idRef.setLineNumber(errLine);
        idRef.setCharPosition(errPos);
        idRef.setFileName(listener.getFileName());
        Parsable tmpData = listener.getParsedDataStack().peek();
        switch (tmpData.getYangConstructType()) {
            case LEAF_DATA: {
                Parsable leaf = listener.getParsedDataStack().pop();
                parentNode = listener.getParsedDataStack().peek();
                listener.getParsedDataStack().push(leaf);
                break;
            }
            case LEAF_LIST_DATA: {
                Parsable leafList = listener.getParsedDataStack().pop();
                parentNode = listener.getParsedDataStack().peek();
                listener.getParsedDataStack().push(leafList);
                break;
            }
            case UNION_DATA: {
                parentNode = listener.getParsedDataStack().peek();
                break;
            }
            case TYPEDEF_DATA: {
                parentNode = listener.getParsedDataStack().peek();
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
            }
        }
        if (!(parentNode instanceof YangNode)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
        }
        idRef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
        YangResolutionInfoImpl<YangIdentityRef> resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(idRef, (YangNode)((Object)parentNode), errLine, errPos);
        IdentityRefListener.addToResolution(resolutionInfo, ctx);
        listener.getParsedDataStack().push(typeData);
        listener.getParsedDataStack().push(idRef);
    }

    public static void processIdentityRefExit(TreeWalkListener listener, GeneratedYangParser.IdentityrefSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT);
        Parsable parsableType = listener.getParsedDataStack().pop();
        if (!(parsableType instanceof YangIdentityRef)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
        }
    }

    private static void addToResolution(YangResolutionInfoImpl<YangIdentityRef> info, GeneratedYangParser.IdentityrefSpecificationContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(info);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }
}

