/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangInclude;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class IncludeListener {
    private IncludeListener() {
    }

    public static void processIncludeEntry(TreeWalkListener listener, GeneratedYangParser.IncludeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.INCLUDE_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.INCLUDE_DATA, ctx);
        YangInclude includeNode = new YangInclude();
        includeNode.setSubModuleName(identifier);
        int errorLine = ctx.getStart().getLine();
        int errorPosition = ctx.getStart().getCharPositionInLine();
        includeNode.setLineNumber(errorLine);
        includeNode.setCharPosition(errorPosition);
        includeNode.setFileName(listener.getFileName());
        listener.getParsedDataStack().push(includeNode);
    }

    public static void processIncludeExit(TreeWalkListener listener, GeneratedYangParser.IncludeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.INCLUDE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpIncludeNode = listener.getParsedDataStack().peek();
        if (tmpIncludeNode instanceof YangInclude) {
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.INCLUDE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case MODULE_DATA: {
                    YangModule module = (YangModule)tmpNode;
                    module.addToIncludeList((YangInclude)tmpIncludeNode);
                    break;
                }
                case SUB_MODULE_DATA: {
                    YangSubModule subModule = (YangSubModule)tmpNode;
                    subModule.addToIncludeList((YangInclude)tmpIncludeNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.INCLUDE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.INCLUDE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

