/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangRangeRestriction;
import org.onosproject.yangutils.datamodel.YangStringRestriction;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.RestrictionResolver;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class LengthRestrictionListener {
    private LengthRestrictionListener() {
    }

    public static void processLengthRestrictionEntry(TreeWalkListener listener, GeneratedYangParser.LengthStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LENGTH_DATA, ctx.length().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData.getYangConstructType() != YangConstructType.TYPE_DATA) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LENGTH_DATA, ctx.length().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)tmpData;
        LengthRestrictionListener.setLengthRestriction(listener, type, ctx);
    }

    private static void setLengthRestriction(TreeWalkListener listener, YangType type, GeneratedYangParser.LengthStatementContext ctx) {
        if (type.getDataType() == YangDataTypes.DERIVED) {
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setLengthRestrictionString(ctx.length().getText());
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setLineNumber(ctx.getStart().getLine());
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setCharPosition(ctx.getStart().getCharPositionInLine());
            return;
        }
        if (type.getDataType() != YangDataTypes.STRING && type.getDataType() != YangDataTypes.BINARY) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.LENGTH_DATA) + " name " + ctx.length().getText() + " can be used to restrict the built-in type string/binary" + " or types derived from string/binary.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        YangRangeRestriction lengthRestriction = null;
        try {
            lengthRestriction = RestrictionResolver.processLengthRestriction(null, ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), false, ctx.length().getText(), listener.getFileName());
        }
        catch (DataModelException e) {
            ParserException parserException = new ParserException(e.getMessage());
            parserException.setCharPosition(e.getCharPositionInLine());
            parserException.setLine(e.getLineNumber());
            throw parserException;
        }
        if (type.getDataType() == YangDataTypes.STRING) {
            YangStringRestriction stringRestriction = (YangStringRestriction)type.getDataTypeExtendedInfo();
            if (stringRestriction == null) {
                stringRestriction = new YangStringRestriction();
                stringRestriction.setFileName(listener.getFileName());
                stringRestriction.setCharPosition(ctx.getStart().getCharPositionInLine());
                stringRestriction.setLineNumber(ctx.getStart().getLine());
                type.setDataTypeExtendedInfo(stringRestriction);
            }
            stringRestriction.setLengthRestriction(lengthRestriction);
        } else {
            type.setDataTypeExtendedInfo(lengthRestriction);
        }
        listener.getParsedDataStack().push(lengthRestriction);
    }

    public static void processLengthRestrictionExit(TreeWalkListener listener, GeneratedYangParser.LengthStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LENGTH_DATA, ctx.length().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData instanceof YangRangeRestriction) {
            listener.getParsedDataStack().pop();
        } else if (!(tmpData instanceof YangType) || ((YangType)tmpData).getDataType() != YangDataTypes.DERIVED) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.LENGTH_DATA, ctx.length().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

