/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class MandatoryListener {
    private MandatoryListener() {
    }

    public static void processMandatoryEntry(TreeWalkListener listener, GeneratedYangParser.MandatoryStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MANDATORY_DATA, "", ListenerErrorLocation.ENTRY);
        boolean isMandatory = ListenerUtil.getValidBooleanValue(ctx.mandatory().getText(), YangConstructType.MANDATORY_DATA, ctx);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        switch (tmpNode.getYangConstructType()) {
            case LEAF_DATA: {
                YangLeaf leaf = (YangLeaf)tmpNode;
                leaf.setMandatory(isMandatory);
                break;
            }
            case CHOICE_DATA: {
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.MANDATORY_DATA, "", ListenerErrorLocation.ENTRY));
            }
        }
    }
}

