/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangBelongsTo;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class PrefixListener {
    private PrefixListener() {
    }

    public static void processPrefixEntry(TreeWalkListener listener, GeneratedYangParser.PrefixStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.PREFIX_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.PREFIX_DATA, ctx);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        switch (tmpNode.getYangConstructType()) {
            case MODULE_DATA: {
                YangModule module = (YangModule)tmpNode;
                module.setPrefix(identifier);
                break;
            }
            case IMPORT_DATA: {
                YangImport importNode = (YangImport)tmpNode;
                importNode.setPrefixId(identifier);
                break;
            }
            case BELONGS_TO_DATA: {
                YangBelongsTo belongstoNode = (YangBelongsTo)tmpNode;
                belongstoNode.setPrefix(identifier);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.PREFIX_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
            }
        }
    }
}

