/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import java.util.Date;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangRevision;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class RevisionListener {
    private RevisionListener() {
    }

    public static void processRevisionEntry(TreeWalkListener listener, GeneratedYangParser.RevisionStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.REVISION_DATA, ctx.dateArgumentString().getText(), ListenerErrorLocation.ENTRY);
        Date date = ListenerUtil.getValidDateFromString(ctx.dateArgumentString().getText(), ctx);
        YangRevision revisionNode = new YangRevision();
        revisionNode.setRevDate(date);
        listener.getParsedDataStack().push(revisionNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processRevisionExit(TreeWalkListener listener, GeneratedYangParser.RevisionStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.REVISION_DATA, ctx.dateArgumentString().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpRevisionNode = listener.getParsedDataStack().peek();
        if (!(tmpRevisionNode instanceof YangRevision)) throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.REVISION_DATA, ctx.dateArgumentString().getText(), ListenerErrorLocation.EXIT));
        listener.getParsedDataStack().pop();
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.REVISION_DATA, ctx.dateArgumentString().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        switch (tmpNode.getYangConstructType()) {
            case MODULE_DATA: {
                YangModule module = (YangModule)tmpNode;
                if (module.getRevision() != null) {
                    Date curRevisionDate = module.getRevision().getRevDate();
                    if (!curRevisionDate.before(((YangRevision)tmpRevisionNode).getRevDate())) return;
                    module.setRevision((YangRevision)tmpRevisionNode);
                    return;
                }
                module.setRevision((YangRevision)tmpRevisionNode);
                return;
            }
            case SUB_MODULE_DATA: {
                YangSubModule subModule = (YangSubModule)tmpNode;
                if (subModule.getRevision() != null) {
                    Date curRevisionDate = subModule.getRevision().getRevDate();
                    if (!curRevisionDate.before(((YangRevision)tmpRevisionNode).getRevDate())) return;
                    subModule.setRevision((YangRevision)tmpRevisionNode);
                    return;
                }
                subModule.setRevision((YangRevision)tmpRevisionNode);
                return;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.REVISION_DATA, ctx.dateArgumentString().getText(), ListenerErrorLocation.EXIT));
            }
        }
    }

    private static boolean validateRevision(TreeWalkListener listener, GeneratedYangParser.RevisionStatementContext ctx) {
        return true;
    }
}

