/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.plugin.buck;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.plugin.buck.YangParsingException;
import org.onosproject.yangutils.tool.CallablePlugin;
import org.onosproject.yangutils.tool.YangToolManager;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;

public class YangGenerator
implements CallablePlugin {
    private final List<File> models;
    private final List<String> depJar;
    private String outputDirectory;
    private final String DEFAULT_JAR_RES_PATH = UtilConstants.SLASH + "yang/resources" + UtilConstants.SLASH;

    YangGenerator(List<File> models, String outputDirectory, List<String> depJar) {
        this.models = models;
        this.depJar = depJar;
        this.outputDirectory = outputDirectory + UtilConstants.SLASH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws YangParsingException {
        List<String> files;
        List<String> list = files = this.getListOfFile();
        synchronized (list) {
            try {
                YangPluginConfig config = new YangPluginConfig();
                config.setCodeGenDir(this.outputDirectory);
                config.resourceGenDir(this.outputDirectory + this.DEFAULT_JAR_RES_PATH);
                ArrayList<YangNode> dependentSchema = new ArrayList<YangNode>();
                for (String jar : this.depJar) {
                    dependentSchema.addAll(DataModelUtils.parseJarFile(jar, this.outputDirectory));
                }
                YangToolManager manager = new YangToolManager();
                manager.compileYangFiles(manager.createYangFileInfoSet(files), dependentSchema, config, this);
            }
            catch (Exception e) {
                throw new YangParsingException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getListOfFile() {
        ArrayList<String> files = new ArrayList<String>();
        if (this.models != null) {
            List<File> list = this.models;
            synchronized (list) {
                files.addAll(this.models.stream().map(File::toString).collect(Collectors.toList()));
            }
        }
        return files;
    }

    @Override
    public void addGeneratedCodeToBundle() {
    }

    @Override
    public void addCompiledSchemaToBundle() throws IOException {
    }

    @Override
    public void addYangFilesToBundle() throws IOException {
    }
}

