/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.plugin.buck;

import com.facebook.buck.io.ProjectFilesystem;
import com.facebook.buck.jvm.java.JarDirectoryStep;
import com.facebook.buck.model.BuildTarget;
import com.facebook.buck.model.BuildTargets;
import com.facebook.buck.rules.AbstractBuildRule;
import com.facebook.buck.rules.AddToRuleKey;
import com.facebook.buck.rules.BuildContext;
import com.facebook.buck.rules.BuildRule;
import com.facebook.buck.rules.BuildRuleParams;
import com.facebook.buck.rules.BuildableContext;
import com.facebook.buck.rules.SourcePath;
import com.facebook.buck.rules.SourcePathResolver;
import com.facebook.buck.step.Step;
import com.facebook.buck.step.fs.MakeCleanDirectoryStep;
import com.facebook.buck.step.fs.MkdirStep;
import com.facebook.buck.step.fs.RmStep;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.onosproject.yangutils.plugin.buck.YangStep;
import org.onosproject.yangutils.utils.UtilConstants;

public class YangLibrary
extends AbstractBuildRule {
    @AddToRuleKey
    private final ImmutableSortedSet<SourcePath> srcs;
    private final BuildRuleParams params;
    private final Path genSrcsDirectory;
    private final Path outputDirectory;
    private final Path output;

    public YangLibrary(BuildRuleParams params, SourcePathResolver resolver, ImmutableSortedSet<SourcePath> srcs) {
        super(params, resolver);
        this.srcs = srcs;
        this.params = params;
        this.genSrcsDirectory = BuildTargets.getGenPath((ProjectFilesystem)this.getProjectFilesystem(), (BuildTarget)params.getBuildTarget(), (String)"%s__yang-gen");
        this.outputDirectory = BuildTargets.getGenPath((ProjectFilesystem)this.getProjectFilesystem(), (BuildTarget)params.getBuildTarget(), (String)"%s__yang-output");
        this.output = Paths.get(String.format("%s/%s-sources.jar", this.outputDirectory, params.getBuildTarget().getShortNameAndFlavorPostfix()), new String[0]);
    }

    public ImmutableList<Step> getBuildSteps(BuildContext buildContext, BuildableContext buildableContext) {
        ImmutableList.Builder steps = ImmutableList.builder();
        steps.add((Object)new RmStep(this.getProjectFilesystem(), this.getPathToOutput(), true, true));
        steps.add((Object)new MkdirStep(this.getProjectFilesystem(), this.outputDirectory));
        steps.add((Object)new MakeCleanDirectoryStep(this.getProjectFilesystem(), this.genSrcsDirectory));
        List<Path> sourcePaths = this.srcs.stream().map(s -> this.getResolver().getRelativePath(s)).collect(Collectors.toList());
        steps.add((Object)new YangStep(this.getProjectFilesystem(), sourcePaths, this.genSrcsDirectory, (ImmutableSortedSet<BuildRule>)this.params.getDeps()));
        steps.add((Object)new JarDirectoryStep(this.getProjectFilesystem(), this.output, ImmutableSortedSet.of((Comparable)this.genSrcsDirectory), null, null));
        return steps.build();
    }

    @Nullable
    public Path getPathToOutput() {
        return this.output;
    }

    public Path getGenSrcsDirectory() {
        File dir = new File(this.genSrcsDirectory.toString() + UtilConstants.SLASH + "yang");
        dir.mkdirs();
        return this.genSrcsDirectory;
    }
}

