/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.javamodel;

import java.io.IOException;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.javadatamodel.YangJavaRpc;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorErrorType;
import org.onosproject.yangutils.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yangutils.utils.io.YangPluginConfig;

public class YangJavaRpcTranslator
extends YangJavaRpc
implements JavaCodeGenerator,
JavaCodeGeneratorInfo {
    private static final long serialVersionUID = 806201622L;
    private transient TempJavaCodeFragmentFiles tempJavaCodeFragmentFiles;

    public YangJavaRpcTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("missing java info in java datamodel node " + this.getName());
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempJavaCodeFragmentFiles;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempJavaCodeFragmentFiles = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        YangJavaModelUtils.updatePackageInfo(this, yangPlugin);
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
        YangNode parent = DataModelUtils.getParentNodeInGenCode(this);
        if (!(parent instanceof RpcNotificationContainer)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_PARENT_NODE, this));
        }
        TempJavaServiceFragmentFiles tempJavaFragmentFiles = ((TempJavaCodeFragmentFilesContainer)((Object)this.getParent())).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        JavaAttributeInfo javaAttributeInfoOfInput = null;
        JavaAttributeInfo javaAttributeInfoOfOutput = null;
        for (YangNode yangNode = this.getChild(); yangNode != null; yangNode = yangNode.getNextSibling()) {
            if (yangNode instanceof YangInput) {
                javaAttributeInfoOfInput = tempJavaFragmentFiles.getChildNodeAsAttributeInParentService(yangNode, this.getParent(), this.getJavaClassNameOrBuiltInType());
                continue;
            }
            if (yangNode instanceof YangOutput) {
                javaAttributeInfoOfOutput = tempJavaFragmentFiles.getChildNodeAsAttributeInParentService(yangNode, this.getParent(), this.getJavaClassNameOrBuiltInType());
                continue;
            }
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_CHILD_NODE, this));
        }
        try {
            ((TempJavaCodeFragmentFilesContainer)((Object)parent)).getTempJavaCodeFragmentFiles().getServiceTempFiles().addJavaSnippetInfoToApplicableTempFiles(javaAttributeInfoOfInput, javaAttributeInfoOfOutput, this.getJavaClassNameOrBuiltInType());
        }
        catch (IOException e) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_EXIT, this, e.getLocalizedMessage()));
        }
    }
}

