/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ListIterator;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.YangRangeInterval;
import org.onosproject.yangutils.datamodel.YangRangeRestriction;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.exceptions.ErrorMessages;
import org.onosproject.yangutils.datamodel.utils.FractionDigits;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;

public class YangDecimal64<T>
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangDecimal64>,
Parsable,
Serializable,
Comparable<YangDecimal64> {
    private static final long serialVersionUID = 8006201668L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final int MIN_FRACTION_DIGITS_VALUE = 1;
    public static final int MAX_FRACTION_DIGITS_VALUE = 18;
    private static final BigDecimal MIN_VALUE = BigDecimal.valueOf(-9.223372036854776E17);
    private static final BigDecimal MAX_VALUE = BigDecimal.valueOf(9.223372036854776E17);
    private static final int MIN_FRACTION_DIGIT_RANGE = 1;
    private static final int MAX_FRACTION_DIGIT_RANGE = 18;
    private static final int ZERO = 0;
    private BigDecimal value;
    private int fractionDigit;
    private T rangeRestrictedExtendedInfo;

    public YangDecimal64() {
    }

    public YangDecimal64(BigDecimal value) {
        this.setValue(value);
    }

    YangDecimal64(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = MIN_VALUE;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = MAX_VALUE;
        } else {
            try {
                this.value = new BigDecimal(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\"" + " is not a valid decimal64.");
            }
        }
        if (this.value.doubleValue() < MIN_VALUE.doubleValue()) {
            throw new DataTypeException("YANG file error : " + valueInString + " is less than minimum value " + MIN_VALUE + ".");
        }
        if (this.value.doubleValue() > MAX_VALUE.doubleValue()) {
            throw new DataTypeException("YANG file error : " + valueInString + " is greater than maximum value " + MAX_VALUE + ".");
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public int getFractionDigit() {
        return this.fractionDigit;
    }

    public void setFractionDigit(int fractionDigit) {
        this.fractionDigit = fractionDigit;
    }

    public T getRangeRestrictedExtendedInfo() {
        return this.rangeRestrictedExtendedInfo;
    }

    public void setRangeRestrictedExtendedInfo(T resolvedExtendedInfo) {
        this.rangeRestrictedExtendedInfo = resolvedExtendedInfo;
    }

    public static YangDecimal64 of(BigDecimal value) {
        return new YangDecimal64(value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.DECIMAL64;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.DECIMAL64_DATA;
    }

    public String toString() {
        return this.value.toString();
    }

    static YangDecimal64 fromString(String valInString) {
        return new YangDecimal64(valInString);
    }

    public boolean isValidFractionDigit() {
        return this.fractionDigit >= 1 && this.fractionDigit <= 18;
    }

    public void validateDecimal64() throws DataModelException {
        YangRangeRestriction rangeRestriction = (YangRangeRestriction)this.getRangeRestrictedExtendedInfo();
        if (rangeRestriction != null) {
            ListIterator rangeListIterator = rangeRestriction.getAscendingRangeIntervals().listIterator();
            boolean isMatched = false;
            while (rangeListIterator.hasNext()) {
                YangRangeInterval rangeInterval = rangeListIterator.next();
                rangeInterval.setCharPosition(this.getCharPosition());
                rangeInterval.setLineNumber(this.getLineNumber());
                rangeInterval.setFileName(this.getFileName());
                BigDecimal startValue = ((YangDecimal64)rangeInterval.getStartValue()).getValue();
                BigDecimal endValue = ((YangDecimal64)rangeInterval.getEndValue()).getValue();
                if (this.value.compareTo(startValue) < 0 || this.value.compareTo(endValue) > 0) continue;
                isMatched = true;
                break;
            }
            if (!isMatched) {
                throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error : decimal64 validation failed.", "decimal64", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
            }
        } else if (!FractionDigits.isValueInDecimal64Range(this.value, this.getFractionDigit())) {
            throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error : decimal64 validation failed.", "decimal64", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
    }

    public void validateRange() throws DataModelException {
        YangRangeRestriction rangeRestriction = (YangRangeRestriction)this.getRangeRestrictedExtendedInfo();
        if (rangeRestriction == null) {
            return;
        }
        ListIterator rangeListIterator = rangeRestriction.getAscendingRangeIntervals().listIterator();
        while (rangeListIterator.hasNext()) {
            YangRangeInterval rangeInterval = rangeListIterator.next();
            rangeInterval.setCharPosition(this.getCharPosition());
            rangeInterval.setLineNumber(this.getLineNumber());
            rangeInterval.setFileName(this.getFileName());
            if (!FractionDigits.isValueInDecimal64Range(((YangDecimal64)rangeInterval.getStartValue()).getValue(), this.getFractionDigit())) {
                throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error : decimal64 validation failed.", "decimal64", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
            }
            if (FractionDigits.isValueInDecimal64Range(((YangDecimal64)rangeInterval.getEndValue()).getValue(), this.getFractionDigit())) continue;
            throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error : decimal64 validation failed.", "decimal64", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
    }

    @Override
    public int compareTo(YangDecimal64 o) {
        return Double.compare(this.value.doubleValue(), o.value.doubleValue());
    }

    public YangRangeRestriction getDefaultRangeRestriction() throws DataModelException {
        YangRangeRestriction refRangeRestriction = new YangRangeRestriction();
        YangRangeInterval<YangDecimal64<T>> rangeInterval = new YangRangeInterval<YangDecimal64<T>>();
        rangeInterval.setCharPosition(this.getCharPosition());
        rangeInterval.setLineNumber(this.getLineNumber());
        rangeInterval.setFileName(this.getFileName());
        FractionDigits.Range range = FractionDigits.getRange(this.fractionDigit);
        rangeInterval.setStartValue(new YangDecimal64<T>(new BigDecimal(range.getMin())));
        rangeInterval.setEndValue(new YangDecimal64<T>(new BigDecimal(range.getMax())));
        refRangeRestriction.addRangeRestrictionInterval(rangeInterval);
        return refRangeRestriction;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }
}

