/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.InvalidOpTypeHolder;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.TraversalType;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangNamespace;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangRevision;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangUses;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;

public abstract class YangNode
extends DefaultLocationInfo
implements Cloneable,
Serializable,
YangSchemaNode,
Comparable<YangNode> {
    private static final long serialVersionUID = 806201601L;
    private YangSchemaNodeIdentifier yangSchemaNodeIdentifier;
    private YangNodeType nodeType;
    private YangNode parent;
    private YangNode child;
    private YangNode nextSibling;
    private YangNode previousSibling;
    private int priority;
    private boolean isToTranslate = true;
    private boolean isOpTypeReq;
    private Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> ysnContextInfoMap;
    private int mandatoryChildCount;
    private YangRevision revision;
    private Map<YangSchemaNodeIdentifier, YangSchemaNode> defaultChildMap;
    private boolean isDescendantNodeAugmented;
    private YangNode referredSchemaNode;

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    private YangNode() {
    }

    protected YangNode(YangNodeType type, Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> ysnContextInfoMap) {
        this.setNodeType(type);
        this.ysnContextInfoMap = ysnContextInfoMap;
    }

    public boolean isDescendantNodeAugmented() {
        return this.isDescendantNodeAugmented;
    }

    public void setDescendantNodeAugmented(boolean descendantNodeAugmented) {
        this.isDescendantNodeAugmented = descendantNodeAugmented;
    }

    public YangNodeType getNodeType() {
        return this.nodeType;
    }

    private void setNodeType(YangNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public YangNode getParent() {
        return this.parent;
    }

    public void setParent(YangNode parent) {
        this.parent = parent;
    }

    public YangNode getChild() {
        return this.child;
    }

    public void setChild(YangNode child) {
        this.child = child;
    }

    public YangNode getNextSibling() {
        return this.nextSibling;
    }

    public void setNextSibling(YangNode sibling) {
        this.nextSibling = sibling;
    }

    public YangNode getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(YangNode previousSibling) {
        this.previousSibling = previousSibling;
    }

    public void addChild(YangNode newChild) throws DataModelException {
        if (newChild.getNodeType() == null) {
            throw new DataModelException("Abstract node cannot be inserted into a tree " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getParent() == null) {
            newChild.setParent(this);
        } else if (newChild.getParent() != this) {
            throw new DataModelException("Node is already part of a tree " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getChild() != null) {
            throw new DataModelException("Child to be added is not atomic, it already has a child " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getNextSibling() != null) {
            throw new DataModelException("Child to be added is not atomic, it already has a next sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getPreviousSibling() != null) {
            throw new DataModelException("Child to be added is not atomic, it already has a previous sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (this.getChild() == null) {
            this.setChild(newChild);
        } else {
            YangNode curNode = this.getChild();
            while (curNode.getNextSibling() != null) {
                curNode = curNode.getNextSibling();
            }
            if (curNode.getNextSibling() == null) {
                curNode.setNextSibling(newChild);
                newChild.setPreviousSibling(curNode);
            }
        }
    }

    protected void processAdditionOfSchemaNodeToParentMap(String name, YangNamespace namespace) {
        this.processAdditionOfSchemaNodeToMap(name, namespace, this, this.getParent());
    }

    public void processAdditionOfSchemaNodeToCurNodeMap(String name, YangNamespace namespace, YangSchemaNode yangSchemaNode) {
        this.processAdditionOfSchemaNodeToMap(name, namespace, yangSchemaNode, this);
    }

    private void processAdditionOfSchemaNodeToMap(String name, YangNamespace namespace, YangSchemaNode yangSchemaNode, YangNode childSchemaMapHolder) {
        YangSchemaNodeIdentifier yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        yangSchemaNodeIdentifier.setName(name);
        yangSchemaNodeIdentifier.setNameSpace(namespace);
        YangSchemaNodeContextInfo yangSchemaNodeContextInfo = new YangSchemaNodeContextInfo();
        yangSchemaNodeContextInfo.setSchemaNode(yangSchemaNode);
        try {
            childSchemaMapHolder.addToChildSchemaMap(yangSchemaNodeIdentifier, yangSchemaNodeContextInfo);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
    }

    @Override
    public int compareTo(YangNode otherNode) {
        if (this.priority == otherNode.getPriority()) {
            return 0;
        }
        return Integer.valueOf(otherNode.getPriority()).compareTo(this.priority);
    }

    public YangNode clone(YangUses yangUses) throws CloneNotSupportedException {
        YangNode clonedNode = (YangNode)super.clone();
        clonedNode.referredSchemaNode = this;
        if (clonedNode instanceof YangLeavesHolder) {
            try {
                DataModelUtils.cloneListOfLeaf((YangLeavesHolder)((Object)clonedNode), yangUses);
                DataModelUtils.cloneListOfLeafList((YangLeavesHolder)((Object)clonedNode), yangUses);
            }
            catch (DataModelException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }
        clonedNode.setParent(null);
        clonedNode.setChild(null);
        clonedNode.setNextSibling(null);
        clonedNode.setPreviousSibling(null);
        clonedNode.yangSchemaNodeIdentifier = clonedNode.yangSchemaNodeIdentifier.clone();
        clonedNode.ysnContextInfoMap = new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>();
        return clonedNode;
    }

    public static void cloneSubTree(YangNode srcRootNode, YangNode dstRootNode, YangUses yangUses) throws DataModelException {
        YangNode nextNodeToClone = srcRootNode;
        YangNode clonedTreeCurNode = dstRootNode;
        YangNode newNode = null;
        if ((nextNodeToClone = nextNodeToClone.getChild()) == null) {
            return;
        }
        TraversalType curTraversal = TraversalType.CHILD;
        try {
            while (nextNodeToClone != srcRootNode) {
                if (nextNodeToClone == null) {
                    throw new DataModelException("Internal error: Cloning failed, source tree null pointer reached " + nextNodeToClone.getName() + " in " + nextNodeToClone.getLineNumber() + " at " + nextNodeToClone.getCharPosition() + " in " + nextNodeToClone.getFileName() + "\"");
                }
                if (curTraversal != TraversalType.PARENT) {
                    newNode = nextNodeToClone.clone(yangUses);
                    YangNode.detectCollisionWhileCloning(clonedTreeCurNode, newNode, curTraversal);
                }
                if (curTraversal == TraversalType.CHILD) {
                    clonedTreeCurNode.addChild(newNode);
                    clonedTreeCurNode = newNode;
                } else if (curTraversal == TraversalType.SIBILING) {
                    clonedTreeCurNode.addNextSibling(newNode);
                    clonedTreeCurNode = newNode;
                } else {
                    if (clonedTreeCurNode instanceof YangLeavesHolder) {
                        DataModelUtils.updateClonedLeavesUnionEnumRef((YangLeavesHolder)((Object)clonedTreeCurNode));
                    }
                    clonedTreeCurNode = clonedTreeCurNode.getParent();
                }
                if (curTraversal != TraversalType.PARENT && nextNodeToClone.getChild() != null) {
                    curTraversal = TraversalType.CHILD;
                    nextNodeToClone = nextNodeToClone.getChild();
                    continue;
                }
                if (nextNodeToClone.getNextSibling() != null) {
                    curTraversal = TraversalType.SIBILING;
                    nextNodeToClone = nextNodeToClone.getNextSibling();
                    continue;
                }
                curTraversal = TraversalType.PARENT;
                nextNodeToClone = nextNodeToClone.getParent();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new DataModelException("Failed to clone the tree " + nextNodeToClone.getName() + " in " + nextNodeToClone.getLineNumber() + " at " + nextNodeToClone.getCharPosition() + " in " + nextNodeToClone.getFileName() + "\"");
        }
    }

    private static void detectCollisionWhileCloning(YangNode currentNode, YangNode newNode, TraversalType addAs) throws DataModelException {
        if (!(currentNode instanceof CollisionDetector) || !(newNode instanceof Parsable)) {
            throw new DataModelException("Node in data model tree does not support collision detection " + newNode.getName() + " in " + newNode.getLineNumber() + " at " + newNode.getCharPosition() + " in " + newNode.getFileName() + "\"");
        }
        CollisionDetector collisionDetector = (CollisionDetector)((Object)currentNode);
        Parsable parsable = (Parsable)((Object)newNode);
        if (addAs == TraversalType.CHILD) {
            collisionDetector.detectCollidingChild(newNode.getName(), parsable.getYangConstructType());
        } else if (addAs == TraversalType.SIBILING) {
            if (!((currentNode = currentNode.getParent()) instanceof CollisionDetector)) {
                throw new DataModelException("Node in data model tree does not support collision detection" + currentNode.getName() + " in " + currentNode.getLineNumber() + " at " + currentNode.getCharPosition() + " in " + currentNode.getFileName() + "\"");
            }
            collisionDetector = (CollisionDetector)((Object)currentNode);
            collisionDetector.detectCollidingChild(newNode.getName(), parsable.getYangConstructType());
        } else {
            throw new DataModelException("Error tree cloning " + currentNode.getName() + " in" + " " + currentNode.getLineNumber() + " at " + currentNode.getCharPosition() + " in " + currentNode.getFileName() + "\"");
        }
    }

    public boolean isToTranslate() {
        return this.isToTranslate;
    }

    public void setToTranslate(boolean toTranslate) {
        this.isToTranslate = toTranslate;
    }

    private void addNextSibling(YangNode newSibling) throws DataModelException {
        if (newSibling.getNodeType() == null) {
            throw new DataModelException("Cloned abstract node cannot be inserted into a tree " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newSibling.getParent() != null) {
            throw new DataModelException("Node is already part of a tree, and cannot be added as a sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        newSibling.setParent(this.getParent());
        if (newSibling.getPreviousSibling() != null) {
            throw new DataModelException("New sibling to be added is not atomic, it already has a previous sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        newSibling.setPreviousSibling(this);
        this.setNextSibling(newSibling);
        if (newSibling.getChild() != null) {
            throw new DataModelException("Sibling to be added is not atomic, it already has a child " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newSibling.getNextSibling() != null) {
            throw new DataModelException("Sibling to be added is not atomic, it already has a next sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
    }

    @Override
    public YangSchemaNodeContextInfo getChildSchema(YangSchemaNodeIdentifier dataNodeIdentifier) throws DataModelException {
        YangSchemaNodeContextInfo childSchemaContext = this.ysnContextInfoMap.get(dataNodeIdentifier);
        if (childSchemaContext == null) {
            throw new DataModelException("Requested " + dataNodeIdentifier.getName() + " is not child in " + this.getName());
        }
        return childSchemaContext;
    }

    @Override
    public int getMandatoryChildCount() throws DataModelException {
        return this.mandatoryChildCount;
    }

    @Override
    public Map<YangSchemaNodeIdentifier, YangSchemaNode> getDefaultChild(YangSchemaNodeIdentifier dataNodeIdentifier) {
        return this.defaultChildMap;
    }

    @Override
    public boolean isNotificationPresent() throws DataModelException {
        throw new DataModelException("Method is called for node other than module/sub-module.");
    }

    public abstract void addToChildSchemaMap(YangSchemaNodeIdentifier var1, YangSchemaNodeContextInfo var2) throws DataModelException;

    public abstract void incrementMandatoryChildCount();

    public void setMandatoryChildCount(int mandatoryChildCount) {
        this.mandatoryChildCount = mandatoryChildCount;
    }

    public abstract void addToDefaultChildMap(YangSchemaNodeIdentifier var1, YangSchemaNode var2);

    public Map<YangSchemaNodeIdentifier, YangSchemaNode> getDefaultChildMap() {
        return this.defaultChildMap;
    }

    public Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> getYsnContextInfoMap() {
        return this.ysnContextInfoMap;
    }

    public void setNameSpaceAndAddToParentSchemaMap() {
        if (this.getParent() != null) {
            this.setNameSpace(this.getParent().getNameSpace());
            this.processAdditionOfSchemaNodeToParentMap(this.getName(), this.getNameSpace());
        } else {
            this.setNameSpace((YangNamespace)((Object)this));
        }
        if (this instanceof YangLeavesHolder) {
            ((YangLeavesHolder)((Object)this)).setLeafNameSpaceAndAddToParentSchemaMap();
        }
    }

    public void setYsnContextInfoMap(Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> ysnContextInfoMap) {
        this.ysnContextInfoMap = ysnContextInfoMap;
    }

    public void addToYsnContextInfoMap(YangSchemaNodeIdentifier yangSchemaNodeIdentifier, YangSchemaNodeContextInfo yangSchemaNodeContextInfo) {
        this.getYsnContextInfoMap().put(yangSchemaNodeIdentifier, yangSchemaNodeContextInfo);
    }

    @Override
    public void isValueValid(String value) throws DataModelException {
        throw new DataModelException("Value validation asked for YANG node. " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
    }

    @Override
    public YangSchemaNodeIdentifier getYangSchemaNodeIdentifier() {
        return this.yangSchemaNodeIdentifier;
    }

    public void setYangSchemaNodeIdentifier(YangSchemaNodeIdentifier yangSchemaNodeIdentifier) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier = yangSchemaNodeIdentifier;
    }

    @Override
    public String getName() {
        return this.yangSchemaNodeIdentifier.getName();
    }

    public void setName(String name) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setName(name);
    }

    @Override
    public YangNamespace getNameSpace() {
        return this.yangSchemaNodeIdentifier.getNameSpace();
    }

    public void setNameSpace(YangNamespace namespace) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setNameSpace(namespace);
    }

    public YangRevision getRevision() {
        return this.revision;
    }

    public void setRevision(YangRevision revision) {
        this.revision = revision;
    }

    @Override
    public YangSchemaNode getNotificationSchemaNode(String notificationNameInEnum) throws DataModelException {
        throw new DataModelException("Method called for schema node other then module/sub-module");
    }

    @Override
    public YangSchemaNode getReferredSchema() {
        return this.referredSchemaNode;
    }

    public boolean isOpTypeReq() {
        if (this instanceof RpcNotificationContainer) {
            this.isOpTypeReq = true;
            return true;
        }
        if (this instanceof InvalidOpTypeHolder) {
            this.isOpTypeReq = false;
            return false;
        }
        return this.getParent().isOpTypeReq();
    }
}

