/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangAppDataStructure;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class DataStructureKeyListener {
    private DataStructureKeyListener() {
    }

    public static void processDataStructureKeyEntry(TreeWalkListener listener, GeneratedYangParser.DataStructureKeyStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.KEY_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (listener.getParsedDataStack().peek() instanceof YangAppDataStructure) {
            YangAppDataStructure dataStructure = (YangAppDataStructure)tmpData;
            dataStructure.setLineNumber(ctx.getStart().getLine());
            dataStructure.setCharPosition(ctx.getStart().getCharPositionInLine());
            dataStructure.setFileName(listener.getFileName());
            String tmpKeyValue = ListenerUtil.removeQuotesAndHandleConcat(ctx.string().getText());
            if (tmpKeyValue.contains(" ")) {
                String[] keyValues;
                for (String keyValue : keyValues = tmpKeyValue.split(" ")) {
                    dataStructure.addKey(keyValue);
                }
            } else {
                dataStructure.addKey(tmpKeyValue);
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.KEY_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
    }
}

