/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangExtension;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class ExtensionListener {
    private ExtensionListener() {
    }

    public static void processExtensionEntry(TreeWalkListener listener, GeneratedYangParser.ExtensionStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.EXTENSION_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.EXTENSION_DATA, ctx);
        YangExtension extension = new YangExtension();
        extension.setLineNumber(ctx.getStart().getLine());
        extension.setCharPosition(ctx.getStart().getCharPositionInLine());
        extension.setFileName(listener.getFileName());
        extension.setName(identifier);
        Parsable curData = listener.getParsedDataStack().peek();
        switch (curData.getYangConstructType()) {
            case MODULE_DATA: {
                YangModule module = (YangModule)curData;
                module.addExtension(extension);
                break;
            }
            case SUB_MODULE_DATA: {
                YangSubModule subModule = (YangSubModule)curData;
                subModule.addExtension(extension);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.EXTENSION_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
            }
        }
        listener.getParsedDataStack().push(extension);
    }

    public static void processExtensionExit(TreeWalkListener listener, GeneratedYangParser.ExtensionStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.EXTENSION_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangExtension)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.EXTENSION_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

