/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class InputListener {
    private InputListener() {
    }

    public static void processInputEntry(TreeWalkListener listener, GeneratedYangParser.InputStatementContext ctx) {
        YangInput yangInput;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.INPUT_DATA, "", ListenerErrorLocation.ENTRY);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangRpc) {
            yangInput = YangDataModelFactory.getYangInputNode(GeneratedLanguage.JAVA_GENERATION);
            yangInput.setName("input");
            yangInput.setLineNumber(ctx.getStart().getLine());
            yangInput.setCharPosition(ctx.getStart().getCharPositionInLine());
            yangInput.setFileName(listener.getFileName());
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(yangInput);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.INPUT_DATA, "", ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.INPUT_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(yangInput);
    }

    public static void processInputExit(TreeWalkListener listener, GeneratedYangParser.InputStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.INPUT_DATA, "", ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangInput)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.INPUT_DATA, "", ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

