/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.ResolvableType;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.linker.exceptions.LinkerException;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class ModuleListener {
    private ModuleListener() {
    }

    public static void processModuleEntry(TreeWalkListener listener, GeneratedYangParser.ModuleStatementContext ctx) {
        ListenerValidation.checkStackIsEmpty(listener, ListenerErrorType.INVALID_HOLDER, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.MODULE_DATA, ctx);
        YangModule yangModule = YangDataModelFactory.getYangModuleNode(GeneratedLanguage.JAVA_GENERATION);
        yangModule.setName(identifier);
        yangModule.setLineNumber(ctx.getStart().getLine());
        yangModule.setCharPosition(ctx.getStart().getCharPositionInLine());
        yangModule.setFileName(listener.getFileName());
        if (ctx.moduleBody().moduleHeaderStatement().yangVersionStatement() == null) {
            yangModule.setVersion((byte)1);
        }
        listener.getParsedDataStack().push(yangModule);
    }

    public static void processModuleExit(TreeWalkListener listener, GeneratedYangParser.ModuleStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangModule)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        YangModule module = (YangModule)tmpNode;
        if (module.getUnresolvedResolutionList(ResolvableType.YANG_COMPILER_ANNOTATION) != null && module.getUnresolvedResolutionList(ResolvableType.YANG_COMPILER_ANNOTATION).size() != 0 && module.getChild() != null) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_CHILD, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        try {
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_IF_FEATURE);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_USES);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_LEAFREF);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_BASE);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
        }
        catch (DataModelException e) {
            LinkerException linkerException = new LinkerException(e.getMessage());
            linkerException.setLine(e.getLineNumber());
            linkerException.setCharPosition(e.getCharPositionInLine());
            linkerException.setFileName(listener.getFileName());
            throw linkerException;
        }
    }
}

