/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangPatternRestriction;
import org.onosproject.yangutils.datamodel.YangStringRestriction;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class PatternRestrictionListener {
    private static final String EMPTY_STRING = "";

    private PatternRestrictionListener() {
    }

    public static void processPatternRestrictionEntry(TreeWalkListener listener, GeneratedYangParser.PatternStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.PATTERN_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData.getYangConstructType() != YangConstructType.TYPE_DATA) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.PATTERN_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)tmpData;
        PatternRestrictionListener.setPatternRestriction(listener, type, ctx);
    }

    private static void setPatternRestriction(TreeWalkListener listener, YangType type, GeneratedYangParser.PatternStatementContext ctx) {
        if (type.getDataType() != YangDataTypes.STRING && type.getDataType() != YangDataTypes.DERIVED) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.PATTERN_DATA) + " name " + ctx.string().getText() + " can be used to restrict the built-in type string or types derived from string.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        String patternArgument = PatternRestrictionListener.getValidPattern(ctx);
        if (type.getDataType() == YangDataTypes.STRING) {
            YangStringRestriction stringRestriction = (YangStringRestriction)type.getDataTypeExtendedInfo();
            if (stringRestriction == null) {
                stringRestriction = new YangStringRestriction();
                stringRestriction.setFileName(listener.getFileName());
                stringRestriction.setCharPosition(ctx.getStart().getCharPositionInLine());
                stringRestriction.setLineNumber(ctx.getStart().getLine());
                type.setDataTypeExtendedInfo(stringRestriction);
                stringRestriction.addPattern(patternArgument);
            } else {
                stringRestriction.addPattern(patternArgument);
            }
            listener.getParsedDataStack().push(stringRestriction);
        } else {
            YangPatternRestriction patternRestriction = ((YangDerivedInfo)type.getDataTypeExtendedInfo()).getPatternRestriction();
            if (patternRestriction == null) {
                patternRestriction = new YangPatternRestriction();
                ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setPatternRestriction(patternRestriction);
                patternRestriction.addPattern(patternArgument);
            } else {
                ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setPatternRestriction(patternRestriction);
                patternRestriction.addPattern(patternArgument);
            }
        }
    }

    public static void processPatternRestrictionExit(TreeWalkListener listener, GeneratedYangParser.PatternStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.PATTERN_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData instanceof YangStringRestriction) {
            listener.getParsedDataStack().pop();
        } else if (!(tmpData instanceof YangType) || ((YangType)tmpData).getDataType() != YangDataTypes.DERIVED) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.PATTERN_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
    }

    private static String getValidPattern(GeneratedYangParser.PatternStatementContext ctx) {
        String userInputPattern = ListenerUtil.removeQuotesAndHandleConcat(ctx.string().getText());
        userInputPattern = userInputPattern.replaceAll("['\"]", EMPTY_STRING);
        try {
            Pattern.compile(userInputPattern);
        }
        catch (PatternSyntaxException exception) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.PATTERN_DATA) + " name " + ctx.string().getText() + " is not a valid regular expression");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return userInputPattern;
    }
}

