/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import java.util.Date;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangInclude;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class RevisionDateListener {
    private RevisionDateListener() {
    }

    public static void processRevisionDateEntry(TreeWalkListener listener, GeneratedYangParser.RevisionDateStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.REVISION_DATE_DATA, ctx.dateArgumentString().getText(), ListenerErrorLocation.ENTRY);
        Date date = ListenerUtil.getValidDateFromString(ctx.dateArgumentString().getText(), ctx);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        switch (tmpNode.getYangConstructType()) {
            case IMPORT_DATA: {
                YangImport importNode = (YangImport)tmpNode;
                importNode.setRevision(date);
                break;
            }
            case INCLUDE_DATA: {
                YangInclude includeNode = (YangInclude)tmpNode;
                includeNode.setRevision(date);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.REVISION_DATE_DATA, ctx.dateArgumentString().getText(), ListenerErrorLocation.ENTRY));
            }
        }
    }
}

