/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.antlr.v4.runtime.ParserRuleContext;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class ShortCaseListener {
    private ShortCaseListener() {
    }

    public static void processShortCaseEntry(TreeWalkListener listener, GeneratedYangParser.ShortCaseStatementContext ctx) {
        ParserRuleContext errorConstructContext;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.SHORT_CASE_DATA, "", ListenerErrorLocation.ENTRY);
        YangCase caseNode = YangDataModelFactory.getYangCaseNode(GeneratedLanguage.JAVA_GENERATION);
        caseNode.setLineNumber(ctx.getStart().getLine());
        caseNode.setCharPosition(ctx.getStart().getCharPositionInLine());
        caseNode.setFileName(listener.getFileName());
        if (ctx.containerStatement() != null) {
            caseNode.setName(ListenerUtil.getValidIdentifier(ctx.containerStatement().identifier().getText(), YangConstructType.CASE_DATA, ctx));
            errorConstructContext = ctx.containerStatement();
        } else if (ctx.listStatement() != null) {
            caseNode.setName(ListenerUtil.getValidIdentifier(ctx.listStatement().identifier().getText(), YangConstructType.CASE_DATA, ctx));
            errorConstructContext = ctx.listStatement();
        } else if (ctx.leafListStatement() != null) {
            caseNode.setName(ListenerUtil.getValidIdentifier(ctx.leafListStatement().identifier().getText(), YangConstructType.CASE_DATA, ctx));
            errorConstructContext = ctx.leafListStatement();
        } else if (ctx.leafStatement() != null) {
            caseNode.setName(ListenerUtil.getValidIdentifier(ctx.leafStatement().identifier().getText(), YangConstructType.CASE_DATA, ctx));
            errorConstructContext = ctx.leafStatement();
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_CHILD, YangConstructType.SHORT_CASE_DATA, "", ListenerErrorLocation.ENTRY));
        }
        int line = ((ParserRuleContext)errorConstructContext).getStart().getLine();
        int charPositionInLine = ((ParserRuleContext)errorConstructContext).getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, caseNode.getName(), YangConstructType.CASE_DATA);
        if (listener.getParsedDataStack().peek() instanceof YangChoice) {
            try {
                ((YangChoice)listener.getParsedDataStack().peek()).addChild(caseNode);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.SHORT_CASE_DATA, caseNode.getName(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.SHORT_CASE_DATA, caseNode.getName(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(caseNode);
    }

    public static void processShortCaseExit(TreeWalkListener listener, GeneratedYangParser.ShortCaseStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.SHORT_CASE_DATA, "", ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangCase)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.SHORT_CASE_DATA, "", ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

