/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.parserutils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangPathArgType;
import org.onosproject.yangutils.datamodel.YangPathOperator;
import org.onosproject.yangutils.datamodel.YangPathPredicate;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.YangRelativePath;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.utils.UtilConstants;

public final class ListenerUtil {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_.-]*");
    private static final String DATE_PATTERN = "[0-9]{4}-([0-9]{2}|[0-9])-([0-9]{2}|[0-9])";
    private static final String NON_NEGATIVE_INTEGER_PATTERN = "[0-9]+";
    private static final Pattern INTEGER_PATTERN = Pattern.compile("[-][0-9]+|[0-9]+");
    private static final Pattern PREDICATE = Pattern.compile("\\[(.*?)\\]");
    private static final String XML = "xml";
    private static final String ONE = "1";
    private static final int IDENTIFIER_LENGTH = 64;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String REGEX_EQUAL = "[=]";
    private static final String REGEX_OPEN_BRACE = "[(]";
    private static YangConstructType pathType;
    private static GeneratedYangParser.PathStatementContext pathCtx;
    private static YangLeafRef yangLeafRef;

    private ListenerUtil() {
    }

    public static String removeQuotesAndHandleConcat(String yangStringData) {
        yangStringData = yangStringData.replace("\"", "");
        String[] tmpData = yangStringData.split(Pattern.quote("+"));
        StringBuilder builder = new StringBuilder();
        for (String yangString : tmpData) {
            builder.append(yangString);
        }
        return builder.toString();
    }

    public static String getValidIdentifier(String identifier, YangConstructType yangConstruct, ParserRuleContext ctx) {
        ParserException parserException;
        String identifierString = ListenerUtil.removeQuotesAndHandleConcat(identifier);
        if (identifierString.length() > 64) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + identifierString + " is " + "greater than 64 characters.");
        } else if (!IDENTIFIER_PATTERN.matcher(identifierString).matches()) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + identifierString + " is not " + "valid.");
        } else if (identifierString.toLowerCase().startsWith(XML)) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " identifier " + identifierString + " must not start with (('X'|'x') ('M'|'m') ('L'|'l')).");
        } else {
            return identifierString;
        }
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static boolean isDateValid(String dateToValidate) {
        if (dateToValidate == null || !dateToValidate.matches(DATE_PATTERN)) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setLenient(false);
        try {
            sdf.parse(dateToValidate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static byte getValidVersion(GeneratedYangParser.YangVersionStatementContext ctx) {
        String value = ListenerUtil.removeQuotesAndHandleConcat(ctx.version().getText());
        if (!value.equals(ONE)) {
            ParserException parserException = new ParserException("YANG file error: Input version not supported");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return Byte.valueOf(value);
    }

    public static int getValidNonNegativeIntegerValue(String integerValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        int valueInInteger;
        String value = ListenerUtil.removeQuotesAndHandleConcat(integerValue);
        if (!value.matches(NON_NEGATIVE_INTEGER_PATTERN)) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        try {
            valueInInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return valueInInteger;
    }

    public static int getValidIntegerValue(String integerValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        int valueInInteger;
        String value = ListenerUtil.removeQuotesAndHandleConcat(integerValue);
        if (!INTEGER_PATTERN.matcher(value).matches()) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        try {
            valueInInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return valueInInteger;
    }

    public static boolean getValidBooleanValue(String booleanValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String value = ListenerUtil.removeQuotesAndHandleConcat(booleanValue);
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not " + "valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static Date getCurrentDateForRevision() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Date date = new Date();
        String dateInString = dateFormat.format(date);
        try {
            Date now = dateFormat.parse(dateInString);
            return date;
        }
        catch (ParseException e) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            throw parserException;
        }
    }

    public static YangNodeIdentifier getValidNodeIdentifier(String nodeIdentifierString, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String tmpIdentifierString = ListenerUtil.removeQuotesAndHandleConcat(nodeIdentifierString);
        String[] tmpData = tmpIdentifierString.split(Pattern.quote(":"));
        if (tmpData.length == 1) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setName(ListenerUtil.getValidIdentifier(tmpData[0], yangConstruct, ctx));
            return nodeIdentifier;
        }
        if (tmpData.length == 2) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setPrefix(ListenerUtil.getValidIdentifier(tmpData[0], yangConstruct, ctx));
            nodeIdentifier.setName(ListenerUtil.getValidIdentifier(tmpData[1], yangConstruct, ctx));
            return nodeIdentifier;
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + nodeIdentifierString + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    private static void valPrefix(List<YangAtomicPath> atomicList, YangLeafRef leafRef) {
        for (YangAtomicPath atomicPath : atomicList) {
            String prefix = atomicPath.getNodeIdentifier().getPrefix();
            YangNode parent = leafRef.getParentNode();
            YangNode rootNode = ListenerUtil.getRootNode(parent);
            List<YangImport> imports = rootNode instanceof YangModule ? ((YangModule)rootNode).getImportList() : ((YangSubModule)rootNode).getImportList();
            ListenerUtil.updatePrefixWithNode(rootNode, imports, prefix, leafRef);
        }
    }

    private static void updatePrefixWithNode(YangNode root, List<YangImport> imports, String prefix, YangLeafRef<?> leafRef) {
        Map<String, String> prefixMap = leafRef.getPrefixAndNode();
        if (prefixMap == null) {
            prefixMap = new HashMap<String, String>();
            leafRef.setPrefixAndNode(prefixMap);
        }
        if (prefix == null || prefix.equals(((YangReferenceResolver)((Object)root)).getPrefix())) {
            prefixMap.put(prefix, root.getName());
            return;
        }
        if (imports != null) {
            for (YangImport yangImp : imports) {
                if (!yangImp.getPrefixId().equals(prefix)) continue;
                prefixMap.put(prefix, yangImp.getModuleName());
            }
        }
    }

    private static YangNode getRootNode(YangNode node) {
        YangNode curNode = node;
        while (!(curNode instanceof YangModule) && !(curNode instanceof YangSubModule)) {
            if (curNode == null) {
                throw new ParserException("Internal datamodel error: Datamodel tree is not correct");
            }
            curNode = curNode.getParent();
        }
        return curNode;
    }

    private static List<YangAtomicPath> validateUniqueValues(String uniquePath, String prefixOfFile, ParserRuleContext ctx) {
        String[] pathInUnique;
        LinkedList<YangAtomicPath> atomicPath = new LinkedList<YangAtomicPath>();
        for (String uniqueValue : pathInUnique = uniquePath.split("/")) {
            YangAtomicPath yangAtomicPathPath = new YangAtomicPath();
            YangNodeIdentifier nodeIdentifier = ListenerUtil.getValidNodeIdentifier(uniqueValue, YangConstructType.UNIQUE_DATA, ctx);
            yangAtomicPathPath.setNodeIdentifier(nodeIdentifier);
            atomicPath.add(yangAtomicPathPath);
            if (nodeIdentifier.getPrefix() == null || nodeIdentifier.getPrefix() == prefixOfFile) continue;
            ParserException parserException = new ParserException("YANG file error : A leaf reference, in unique, must refer to a leaf in the list");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return atomicPath;
    }

    public static void validateUniqueInList(YangList yangList, ParserRuleContext ctx) {
        String prefixOfTheFile = ListenerUtil.getPrefixInFileOfTheCurrentNode(yangList);
        List<String> uniques = yangList.getUniqueList();
        if (uniques != null && !uniques.isEmpty()) {
            ListIterator<String> uniqueList = uniques.listIterator();
            while (uniqueList.hasNext()) {
                YangLeaf leaf;
                String pathInUnique = (String)uniqueList.next();
                List<YangAtomicPath> atomicPathInUnique = ListenerUtil.validateUniqueValues(pathInUnique, prefixOfTheFile, ctx);
                YangAtomicPath leafInPath = atomicPathInUnique.get(atomicPathInUnique.size() - 1);
                if (atomicPathInUnique.size() == 1) {
                    leaf = ListenerUtil.getReferenceLeafFromUnique(yangList, leafInPath);
                } else {
                    atomicPathInUnique.remove(atomicPathInUnique.size() - 1);
                    YangNode holderOfLeaf = ListenerUtil.getNodeUnderListFromPath(atomicPathInUnique, yangList, ctx);
                    leaf = ListenerUtil.getReferenceLeafFromUnique(holderOfLeaf, leafInPath);
                }
                if (leaf != null) continue;
                ParserException parserException = new ParserException("YANG file error : A leaf reference, in unique, must refer to a leaf under the list");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
        }
    }

    private static YangNode getNodeUnderListFromPath(List<YangAtomicPath> uniquePath, YangNode node, ParserRuleContext ctx) {
        ListIterator<YangAtomicPath> nodesInReference = uniquePath.listIterator();
        YangNode potentialReferredNode = node.getChild();
        while (nodesInReference.hasNext()) {
            YangAtomicPath nodeInUnique = (YangAtomicPath)nodesInReference.next();
            YangNode referredNode = ListenerUtil.getReferredNodeFromTheUniqueNodes(nodeInUnique.getNodeIdentifier(), potentialReferredNode);
            if (referredNode == null) {
                ParserException parserException = new ParserException("YANG file error : The target node in unique reference path is invalid");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
            potentialReferredNode = referredNode.getChild();
        }
        return potentialReferredNode;
    }

    private static YangNode getReferredNodeFromTheUniqueNodes(YangNodeIdentifier nodeInUnique, YangNode potentialReferredNode) {
        while (potentialReferredNode != null) {
            if (potentialReferredNode.getName().equals(nodeInUnique.getName())) {
                return potentialReferredNode;
            }
            potentialReferredNode = potentialReferredNode.getNextSibling();
        }
        return null;
    }

    private static YangLeaf getReferenceLeafFromUnique(YangNode nodeForLeaf, YangAtomicPath leafInUnique) {
        YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)nodeForLeaf);
        List<YangLeaf> leaves = leavesHolder.getListOfLeaf();
        if (leaves != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                if (!leafInUnique.getNodeIdentifier().getName().equals(leaf.getName())) continue;
                return leaf;
            }
        }
        return null;
    }

    public static String getPrefixInFileOfTheCurrentNode(YangNode node) {
        String prefixInFile;
        while (!(node instanceof YangReferenceResolver)) {
            if ((node = node.getParent()) != null) continue;
            throw new ParserException("Internal datamodel error: Datamodel tree is not correct");
        }
        if (node instanceof YangModule) {
            YangModule yangModule = (YangModule)node;
            prefixInFile = yangModule.getPrefix();
        } else {
            YangSubModule yangSubModule = (YangSubModule)node;
            prefixInFile = yangSubModule.getPrefix();
        }
        return prefixInFile;
    }

    private static String getMatchedPredicate(String str) {
        Matcher matcher = PREDICATE.matcher(str);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static List<YangAtomicPath> getValidAbsoluteSchemaNodeId(String argumentString, YangConstructType yangConstructType, ParserRuleContext ctx) {
        String[] tmpData;
        ArrayList<YangAtomicPath> targetNodes = new ArrayList<YangAtomicPath>();
        String tmpSchemaNodeId = ListenerUtil.removeQuotesAndHandleConcat(argumentString);
        if (!tmpSchemaNodeId.startsWith(UtilConstants.SLASH)) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstructType) + " name " + argumentString + "is not valid");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        for (String nodeIdentifiers : tmpData = tmpSchemaNodeId.replaceFirst("^" + UtilConstants.SLASH, "").split(UtilConstants.SLASH)) {
            YangNodeIdentifier yangNodeIdentifier = ListenerUtil.getValidNodeIdentifier(nodeIdentifiers, yangConstructType, ctx);
            YangAtomicPath yangAbsPath = new YangAtomicPath();
            yangAbsPath.setNodeIdentifier(yangNodeIdentifier);
            targetNodes.add(yangAbsPath);
        }
        return targetNodes;
    }

    public static void handleUnsupportedYangConstruct(YangConstructType type, ParserRuleContext ctx, String errorInfo, String fileName) {
        ParserException parserException = new ParserException("YANG file error : \"" + YangConstructType.getYangConstructType(type) + "\"" + errorInfo);
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
    }

    public static Date getValidDateFromString(String dateInString, ParserRuleContext ctx) {
        String dateArgument = ListenerUtil.removeQuotesAndHandleConcat(dateInString);
        if (!dateArgument.matches(DATE_PATTERN)) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setLenient(false);
        try {
            return sdf.parse(dateArgument);
        }
        catch (ParseException e) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    public static String getValidPrefix(String inputString, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String tmpPrefixString = ListenerUtil.removeQuotesAndHandleConcat(inputString);
        String[] tmpData = tmpPrefixString.split(Pattern.quote(":"));
        if (tmpData.length == 2) {
            return tmpData[0];
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + inputString + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static void validatePath(String path, YangConstructType type, GeneratedYangParser.PathStatementContext ctx, YangLeafRef leafRef) {
        String concatPath = ListenerUtil.removeQuotesAndHandleConcat(path);
        pathType = type;
        pathCtx = ctx;
        yangLeafRef = leafRef;
        if (!concatPath.startsWith("/") && !concatPath.startsWith("..")) {
            throw ListenerUtil.getPathException();
        }
        leafRef.setPath(concatPath);
        if (concatPath.startsWith("/")) {
            LinkedList<YangAtomicPath> atomicList = new LinkedList<YangAtomicPath>();
            ListenerUtil.valAbsPath(concatPath, atomicList);
            leafRef.setPathType(YangPathArgType.ABSOLUTE_PATH);
            ListenerUtil.valPrefix(atomicList, leafRef);
            leafRef.setAtomicPath(atomicList);
            return;
        }
        leafRef.setPathType(YangPathArgType.RELATIVE_PATH);
        ListenerUtil.valRelPath(concatPath, leafRef);
    }

    private static void valRelPath(String path, YangLeafRef leafRef) {
        YangRelativePath relPath = new YangRelativePath();
        int count = 0;
        while (path.startsWith("../")) {
            path = path.replaceFirst("../", "");
            ++count;
        }
        if (path.isEmpty()) {
            throw ListenerUtil.getPathException();
        }
        ArrayList<YangAtomicPath> atomicList = new ArrayList<YangAtomicPath>();
        relPath.setAncestorNodeCount(count);
        ListenerUtil.valAbsPath("/" + path, atomicList);
        ListenerUtil.valPrefix(atomicList, leafRef);
        relPath.setAtomicPathList(atomicList);
        leafRef.setRelativePath(relPath);
    }

    private static void valAbsPath(String path, List<YangAtomicPath> atomics) {
        String comPath = path;
        while (comPath != null) {
            if ((comPath = comPath.substring(1)).isEmpty()) {
                throw ListenerUtil.getPathException();
            }
            int nodeId = comPath.indexOf(47);
            int predicate = comPath.indexOf(91);
            if (predicate < nodeId && predicate != -1) {
                comPath = ListenerUtil.getPathWithPredicate(comPath, atomics);
                continue;
            }
            comPath = ListenerUtil.getPath(comPath, atomics);
        }
    }

    private static String getPathWithPredicate(String path, List<YangAtomicPath> atomics) {
        String[] node = new String[2];
        int bracket = path.indexOf(91);
        node[0] = path.substring(0, bracket);
        node[1] = path.substring(bracket);
        return ListenerUtil.getParsedPath(node[0], node[1], atomics);
    }

    public static String getParsedPath(String nodeId, String path, List<YangAtomicPath> atomics) {
        String comPath = path;
        ArrayList<String> predicateList = new ArrayList<String>();
        while (comPath.startsWith("[")) {
            String matchedVal = ListenerUtil.getMatchedPredicate(comPath);
            if (matchedVal == null || matchedVal.isEmpty()) {
                throw ListenerUtil.getPathException();
            }
            predicateList.add(matchedVal);
            comPath = comPath.substring(matchedVal.length());
        }
        YangAtomicPath atomicPath = new YangAtomicPath();
        YangNodeIdentifier validId = ListenerUtil.getValidNodeIdentifier(nodeId, pathType, pathCtx);
        List<YangPathPredicate> predicates = ListenerUtil.valPathPredicates(predicateList);
        atomicPath.setNodeIdentifier(validId);
        atomicPath.setPathPredicatesList(predicates);
        atomics.add(atomicPath);
        return comPath;
    }

    private static List<YangPathPredicate> valPathPredicates(List<String> predicates) {
        ArrayList<YangPathPredicate> result = new ArrayList<YangPathPredicate>();
        for (String p : predicates) {
            p = p.substring(1, p.length() - 1);
            result.add(ListenerUtil.valPathEqualityExp(p.trim()));
        }
        return result;
    }

    private static YangPathPredicate valPathEqualityExp(String predicate) {
        String[] exp = predicate.split(REGEX_EQUAL);
        YangNodeIdentifier nodeId = ListenerUtil.getValidNodeIdentifier(exp[0].trim(), pathType, pathCtx);
        YangRelativePath relPath = ListenerUtil.valPathKeyExp(exp[1].trim());
        YangPathPredicate pathPredicate = new YangPathPredicate();
        pathPredicate.setNodeId(nodeId);
        pathPredicate.setPathOp(YangPathOperator.EQUALTO);
        pathPredicate.setRelPath(relPath);
        return pathPredicate;
    }

    private static YangRelativePath valPathKeyExp(String relPath) {
        String[] relative = relPath.split("/");
        int count = 0;
        ArrayList<String> atomicContent = new ArrayList<String>();
        for (String val : relative) {
            if (val.trim().equals("..")) {
                ++count;
                continue;
            }
            atomicContent.add(val);
        }
        YangRelativePath relativePath = new YangRelativePath();
        relativePath.setAncestorNodeCount(count);
        relativePath.setAtomicPathList(ListenerUtil.valRelPathKeyExp(atomicContent));
        return relativePath;
    }

    private static List<YangAtomicPath> valRelPathKeyExp(List<String> content) {
        String current = content.get(0);
        String[] curStr = current.trim().split(REGEX_OPEN_BRACE);
        if (!curStr[0].trim().equals("current") || !curStr[1].trim().equals(")")) {
            throw ListenerUtil.getPathException();
        }
        content.remove(0);
        ArrayList<YangAtomicPath> atomicList = new ArrayList<YangAtomicPath>();
        for (String relPath : content) {
            YangNodeIdentifier nodeId = ListenerUtil.getValidNodeIdentifier(relPath, pathType, pathCtx);
            YangAtomicPath atomicPath = new YangAtomicPath();
            atomicPath.setNodeIdentifier(nodeId);
            atomicList.add(atomicPath);
        }
        return atomicList;
    }

    public static String getPath(String path, List<YangAtomicPath> atomicList) {
        String nodeId;
        String comPath = path;
        if (comPath.contains("/")) {
            nodeId = comPath.substring(0, comPath.indexOf(47));
            comPath = comPath.substring(comPath.indexOf(47));
        } else {
            nodeId = comPath;
            comPath = null;
        }
        YangNodeIdentifier validNodeId = ListenerUtil.getValidNodeIdentifier(nodeId, pathType, pathCtx);
        YangAtomicPath atomicPath = new YangAtomicPath();
        atomicPath.setNodeIdentifier(validNodeId);
        atomicList.add(atomicPath);
        return comPath;
    }

    private static ParserException getPathException() {
        ParserException exception = new ParserException("YANG file error : Path " + yangLeafRef.getPath() + " does not follow valid path syntax");
        exception.setLine(pathCtx.getStart().getLine());
        exception.setCharPosition(pathCtx.getStart().getCharPositionInLine());
        return exception;
    }
}

