/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.plugin.buck;

import java.io.File;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.parser.impl.YangUtilsParserManager;
import org.onosproject.yangutils.plugin.buck.YangParsingException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorUtil;
import org.onosproject.yangutils.utils.io.YangPluginConfig;

public class YangGenerator {
    private final List<File> models;
    private String outputDirectory;

    public YangGenerator(List<File> models, String outputDirectory) {
        this.models = models;
        this.outputDirectory = outputDirectory + "/";
    }

    public void execute() throws YangParsingException {
        for (File model : this.models) {
            try {
                YangPluginConfig config = new YangPluginConfig();
                config.setCodeGenDir(this.outputDirectory);
                YangNode yangNode = new YangUtilsParserManager().getDataModel(model.toString());
                JavaCodeGeneratorUtil.generateJavaCode(yangNode, config);
            }
            catch (Exception e) {
                throw new YangParsingException(e);
            }
        }
    }
}

