/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.javadatamodel.JavaQualifiedTypeInfo;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;

public final class JavaAttributeInfo {
    private YangType<?> attrType;
    private String name;
    private boolean isListAttr;
    private boolean isQualifiedName;
    private JavaQualifiedTypeInfoTranslator importInfo;
    private YangCompilerAnnotation compilerAnnotation;
    private boolean isIntConflict;
    private boolean isLongConflict;
    private boolean isShortConflict;

    private JavaAttributeInfo() {
    }

    public JavaAttributeInfo(YangType<?> attrType, String name, boolean isListAttr, boolean isQualifiedName) {
        this.attrType = attrType;
        this.name = name;
        this.isListAttr = isListAttr;
        this.isQualifiedName = isQualifiedName;
    }

    public YangType<?> getAttributeType() {
        return this.attrType;
    }

    public void setAttributeType(YangType<?> type) {
        this.attrType = type;
    }

    public String getAttributeName() {
        if (this.name == null) {
            throw new TranslatorException("Expected java attribute name is null");
        }
        return this.name;
    }

    public void setAttributeName(String attrName) {
        this.name = attrName;
    }

    public boolean isListAttr() {
        return this.isListAttr;
    }

    private void setListAttr(boolean isList) {
        this.isListAttr = isList;
    }

    public boolean isQualifiedName() {
        return this.isQualifiedName;
    }

    private void setIsQualifiedAccess(boolean isQualified) {
        this.isQualifiedName = isQualified;
    }

    public JavaQualifiedTypeInfoTranslator getImportInfo() {
        return this.importInfo;
    }

    public void setImportInfo(JavaQualifiedTypeInfoTranslator importInfo) {
        this.importInfo = importInfo;
    }

    public YangCompilerAnnotation getCompilerAnnotation() {
        return this.compilerAnnotation;
    }

    public void setCompilerAnnotation(YangCompilerAnnotation compilerAnnotation) {
        this.compilerAnnotation = compilerAnnotation;
    }

    public boolean isIntConflict() {
        return this.isIntConflict;
    }

    void setIntConflict(boolean intConflict) {
        this.isIntConflict = intConflict;
    }

    public boolean isLongConflict() {
        return this.isLongConflict;
    }

    void setLongConflict(boolean longConflict) {
        this.isLongConflict = longConflict;
    }

    public boolean isShortConflict() {
        return this.isShortConflict;
    }

    public void setShortConflict(boolean shortConflict) {
        this.isShortConflict = shortConflict;
    }

    public static JavaAttributeInfo getAttributeInfoForTheData(JavaQualifiedTypeInfo importInfo, String attributeName, YangType<?> attributeType, boolean isQualifiedAccess, boolean isListAttribute) {
        if (attributeType != null) {
            attributeType = JavaFileGeneratorUtils.isTypeLeafref(attributeType);
        }
        attributeName = JavaFileGeneratorUtils.isTypeNameLeafref(attributeName, attributeType);
        JavaAttributeInfo newAttr = new JavaAttributeInfo();
        newAttr.setImportInfo((JavaQualifiedTypeInfoTranslator)importInfo);
        newAttr.setAttributeName(attributeName);
        newAttr.setAttributeType(attributeType);
        newAttr.setIsQualifiedAccess(isQualifiedAccess);
        newAttr.setListAttr(isListAttribute);
        return newAttr;
    }

    public static JavaAttributeInfo getAttributeInfoForTheData(JavaQualifiedTypeInfoTranslator importInfo, String attributeName, YangType<?> attributeType, boolean isQualifiedAccess, boolean isListAttribute, YangCompilerAnnotation compilerAnnotation) {
        JavaAttributeInfo newAttr = JavaAttributeInfo.getAttributeInfoForTheData(importInfo, attributeName, attributeType, isQualifiedAccess, isListAttribute);
        newAttr.setCompilerAnnotation(compilerAnnotation);
        return newAttr;
    }
}

