/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.utils.StringGenerator;

public class JavaImportData {
    private boolean isListToImport;
    private boolean isQueueToImport;
    private boolean isSetToImport;
    private final SortedSet<JavaQualifiedTypeInfoTranslator> importSet = new TreeSet<JavaQualifiedTypeInfoTranslator>();

    void setIfListImported(boolean isList) {
        this.isListToImport = isList;
    }

    void setQueueToImport(boolean queueToImport) {
        this.isQueueToImport = queueToImport;
    }

    void setSetToImport(boolean setToImport) {
        this.isSetToImport = setToImport;
    }

    public SortedSet<JavaQualifiedTypeInfoTranslator> getImportSet() {
        return Collections.unmodifiableSortedSet(this.importSet);
    }

    public boolean addImportInfo(JavaQualifiedTypeInfoTranslator newImportInfo, String className, String classPkg) {
        if (newImportInfo.getClassInfo().contentEquals(className)) {
            return true;
        }
        if (newImportInfo.getPkgInfo() == null) {
            return false;
        }
        if (newImportInfo.getPkgInfo().contentEquals(classPkg)) {
            return false;
        }
        for (JavaQualifiedTypeInfoTranslator curImportInfo : this.getImportSet()) {
            if (!curImportInfo.getClassInfo().contentEquals(newImportInfo.getClassInfo())) continue;
            return !curImportInfo.getPkgInfo().contentEquals(newImportInfo.getPkgInfo());
        }
        this.importSet.add(newImportInfo);
        return false;
    }

    public List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>();
        for (JavaQualifiedTypeInfoTranslator importInfo : this.getImportSet()) {
            if (importInfo.getPkgInfo().equals("") || importInfo.getClassInfo() == null || importInfo.getPkgInfo().equals("java.lang")) continue;
            String importString = StringGenerator.getImportString(importInfo.getPkgInfo(), importInfo.getClassInfo());
            imports.add(importString);
        }
        if (this.isListToImport) {
            imports.add(this.getImportForList());
        }
        if (this.isQueueToImport) {
            imports.add(this.getImportForQueue());
        }
        if (this.isSetToImport) {
            imports.add(this.getImportForSet());
        }
        Collections.sort(imports);
        return imports;
    }

    String getImportForHashAndEquals() {
        return StringGenerator.getImportString("java.util", "Objects");
    }

    public String getImportForToString() {
        return StringGenerator.getImportString("com.google.common.base", "MoreObjects");
    }

    public String getImportForToBitSet() {
        return StringGenerator.getImportString("java.util", "BitSet");
    }

    public String getImportForToBase64() {
        return StringGenerator.getImportString("java.util", "Base64");
    }

    public String getImportForPattern() {
        return StringGenerator.getImportString("java.util.regex", "Pattern");
    }

    String getImportForList() {
        return StringGenerator.getImportString("java.util", "List");
    }

    private String getImportForQueue() {
        return StringGenerator.getImportString("java.util", "Queue");
    }

    private String getImportForSet() {
        return StringGenerator.getImportString("java.util", "Set");
    }

    public String getListenerServiceImport() {
        return StringGenerator.getImportString("org.onosproject.event", "ListenerService");
    }

    String getAbstractEventsImport() {
        return StringGenerator.getImportString("org.onosproject.event", "AbstractEvent");
    }

    String getEventListenerImport() {
        return StringGenerator.getImportString("org.onosproject.event", "EventListener");
    }

    String getMapImport() {
        return StringGenerator.getImportString("java.util", "Map");
    }

    String getHashMapImport() {
        return StringGenerator.getImportString("java.util", "HashMap");
    }

    public String getBigIntegerImport() {
        return StringGenerator.getImportString("java.math", "BigInteger");
    }
}

