/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;

public class TempJavaBeanFragmentFiles
extends TempJavaFragmentFiles {
    private static final String CONSTRUCTOR_FILE_NAME = "Constructor";
    private final File constructorImplTempFileHandle;

    TempJavaBeanFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        super(javaFileInfo);
        this.addGeneratedTempFile(32);
        this.constructorImplTempFileHandle = this.getTemporaryFileHandle(CONSTRUCTOR_FILE_NAME);
    }

    public File getConstructorImplTempFileHandle() {
        return this.constructorImplTempFileHandle;
    }

    private void addConstructor(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.constructorImplTempFileHandle, MethodsGenerator.getConstructor(attr, this.getGeneratedJavaFiles()));
    }

    @Override
    void addJavaSnippetInfoToApplicableTempFiles(JavaAttributeInfo newAttrInfo, YangPluginConfig pluginConfig) throws IOException {
        super.addJavaSnippetInfoToApplicableTempFiles(newAttrInfo, pluginConfig);
        this.addConstructor(newAttrInfo);
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.constructorImplTempFileHandle, true);
        super.freeTemporaryResources(isErrorOccurred);
    }
}

