/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangEnum;
import org.onosproject.yangutils.datamodel.YangEnumeration;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaTypeTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaEnumerationFragmentFiles
extends TempJavaFragmentFiles {
    private static final String ENUM_CLASS_TEMP_FILE_NAME = "EnumClass";
    private final File enumClassTempFileHandle;
    private File enumClassJavaFileHandle;
    private boolean isEnumClass;

    public TempJavaEnumerationFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        super(javaFileInfo);
        this.addGeneratedTempFile(4096);
        this.enumClassTempFileHandle = this.getTemporaryFileHandle(ENUM_CLASS_TEMP_FILE_NAME);
    }

    public File getEnumClassTempFileHandle() {
        return this.enumClassTempFileHandle;
    }

    private void addAttributesForEnumClass(YangEnum yangEnum) throws IOException {
        this.appendToFile(this.enumClassTempFileHandle, JavaCodeSnippetGen.generateEnumAttributeStringWithSchemaName(yangEnum.getNamedValue(), yangEnum.getValue()));
    }

    public void addEnumAttributeToTempFiles(YangNode curNode, YangPluginConfig config) throws IOException {
        this.addJavaSnippetInfoToApplicableTempFiles(this.getJavaAttributeForEnum(config), config);
        if (curNode instanceof YangEnumeration) {
            YangEnumeration enumeration = (YangEnumeration)curNode;
            for (YangEnum curEnum : enumeration.getEnumSet()) {
                String enumName = curEnum.getNamedValue();
                if (enumName.matches("\\d.*")) {
                    String prefix = YangIoUtils.getPrefixForIdentifier(config.getConflictResolver());
                    if (prefix != null) {
                        curEnum.setNamedValue(prefix + enumName);
                    } else {
                        curEnum.setNamedValue("yangAutoPrefix" + enumName);
                    }
                }
                this.addJavaSnippetInfoToApplicableTempFiles(curEnum);
            }
        } else {
            throw new TranslatorException("current node should be of enumeration type. " + curNode.getName() + " in " + curNode.getLineNumber() + " at " + curNode.getCharPosition() + " in " + curNode.getFileName());
        }
    }

    private JavaAttributeInfo getJavaAttributeForEnum(YangPluginConfig config) {
        YangJavaTypeTranslator javaType = new YangJavaTypeTranslator();
        javaType.setDataType(YangDataTypes.INT32);
        javaType.setDataTypeName("int");
        javaType.updateJavaQualifiedInfo(config.getConflictResolver());
        return JavaAttributeInfo.getAttributeInfoForTheData(javaType.getJavaQualifiedInfo(), javaType.getDataTypeName(), javaType, this.getIsQualifiedAccessOrAddToImportList(javaType.getJavaQualifiedInfo()), false);
    }

    private void addJavaSnippetInfoToApplicableTempFiles(YangEnum yangEnum) throws IOException {
        this.addAttributesForEnumClass(yangEnum);
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        List<String> imports = this.getJavaImportData().getImports();
        JavaIdentifierSyntax.createPackage(curNode);
        this.enumClassJavaFileHandle = this.getJavaFileHandle(this.getJavaClassName(""));
        JavaFileGenerator.generateEnumClassFile(this.enumClassJavaFileHandle, curNode, imports);
        this.freeTemporaryResources(false);
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.enumClassJavaFileHandle, isErrorOccurred);
        FileSystemUtil.closeFile(this.enumClassTempFileHandle, true);
        if (this.isEnumClass) {
            super.freeTemporaryResources(isErrorOccurred);
        }
    }

    public boolean isEnumClass() {
        return this.isEnumClass;
    }

    public void setEnumClass(boolean enumClass) {
        this.isEnumClass = enumClass;
    }
}

