/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaEventFragmentFiles
extends TempJavaFragmentFiles {
    private static final String EVENT_SUBJECT_NAME_SUFFIX = "EventSubject";
    private static final String EVENT_ENUM_FILE_NAME = "EventEnum";
    private static final String EVENT_METHOD_FILE_NAME = "EventMethod";
    private static final String EVENT_SUBJECT_ATTRIBUTE_FILE_NAME = "EventSubjectAttribute";
    private static final String EVENT_SUBJECT_GETTER_FILE_NAME = "EventSubjectGetter";
    private static final String EVENT_SUBJECT_SETTER_FILE_NAME = "EventSubjectSetter";
    private static final String JAVA_FILE_EXTENSION = ".java";
    private File eventSubjectJavaFileHandle;
    private File eventListenerJavaFileHandle;
    private File eventJavaFileHandle;
    private final File eventEnumTempFileHandle;
    private final File eventMethodTempFileHandle;
    private final File eventSubjectAttributeTempFileHandle;
    private final File eventSubjectGetterTempFileHandle;
    private final File eventSubjectSetterTempFileHandle;

    TempJavaEventFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        this.setJavaExtendsListHolder(new JavaExtendsListHolder());
        this.setJavaImportData(new JavaImportData());
        this.setJavaFileInfo(javaFileInfo);
        this.setAbsoluteDirPath(YangIoUtils.getAbsolutePackagePath(this.getJavaFileInfo().getBaseCodeGenPath(), this.getJavaFileInfo().getPackageFilePath()));
        this.addGeneratedTempFile(32768);
        this.addGeneratedTempFile(65536);
        this.addGeneratedTempFile(131072);
        this.addGeneratedTempFile(262144);
        this.addGeneratedTempFile(524288);
        this.eventEnumTempFileHandle = this.getTemporaryFileHandle(EVENT_ENUM_FILE_NAME);
        this.eventMethodTempFileHandle = this.getTemporaryFileHandle(EVENT_METHOD_FILE_NAME);
        this.eventSubjectAttributeTempFileHandle = this.getTemporaryFileHandle(EVENT_SUBJECT_ATTRIBUTE_FILE_NAME);
        this.eventSubjectGetterTempFileHandle = this.getTemporaryFileHandle(EVENT_SUBJECT_GETTER_FILE_NAME);
        this.eventSubjectSetterTempFileHandle = this.getTemporaryFileHandle(EVENT_SUBJECT_SETTER_FILE_NAME);
    }

    public File getEventEnumTempFileHandle() {
        return this.eventEnumTempFileHandle;
    }

    public File getEventMethodTempFileHandle() {
        return this.eventMethodTempFileHandle;
    }

    public File getEventSubjectAttributeTempFileHandle() {
        return this.eventSubjectAttributeTempFileHandle;
    }

    public File getEventSubjectGetterTempFileHandle() {
        return this.eventSubjectGetterTempFileHandle;
    }

    public File getEventSubjectSetterTempFileHandle() {
        return this.eventSubjectSetterTempFileHandle;
    }

    private static String getEventFileContents(String eventClassname, String classname) {
        return "\n    /**\n     * Creates " + classname + " event with type and subject.\n" + "     *\n" + "     * @param type event type\n" + "     * @param subject subject " + classname + "\n" + "     */\n" + "    public " + eventClassname + "(Type type, " + YangIoUtils.getCapitalCase(classname) + " subject) {\n" + "        super(type, subject);\n" + "    }\n" + "\n" + "    /**\n" + "     * Creates " + classname + " event with type, subject and time.\n" + "     *\n" + "     * @param type event type\n" + "     * @param subject subject " + classname + "\n" + "     * @param time time of event\n" + "     */\n" + "    public " + eventClassname + "(Type type, " + YangIoUtils.getCapitalCase(classname) + " subject, long time) {\n" + "        super(type, subject, time);\n" + "    }\n" + "\n";
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        this.generateEventJavaFile(curNode);
        this.generateEventListenerJavaFile(curNode);
        this.generateEventSubjectJavaFile(curNode);
        this.freeTemporaryResources(false);
    }

    private void generateEventJavaFile(YangNode curNode) throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getJavaImportData().getAbstractEventsImport());
        String curNodeInfo = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getJavaName());
        String nodeName = curNodeInfo + "Event";
        this.addEnumMethod(nodeName, curNodeInfo + EVENT_SUBJECT_NAME_SUFFIX);
        this.eventJavaFileHandle = this.getJavaFileHandle(curNode, curNodeInfo + "Event");
        JavaFileGenerator.generateEventFile(this.eventJavaFileHandle, curNode, imports);
    }

    private void generateEventListenerJavaFile(YangNode curNode) throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getJavaImportData().getEventListenerImport());
        String curNodeInfo = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getJavaName());
        this.eventListenerJavaFileHandle = this.getJavaFileHandle(curNode, curNodeInfo + "EventListener");
        JavaFileGenerator.generateEventListenerFile(this.eventListenerJavaFileHandle, curNode, imports);
    }

    private void generateEventSubjectJavaFile(YangNode curNode) throws IOException {
        String curNodeInfo = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo().getJavaName());
        this.eventSubjectJavaFileHandle = this.getJavaFileHandle(curNode, curNodeInfo + EVENT_SUBJECT_NAME_SUFFIX);
        JavaFileGenerator.generateEventSubjectFile(this.eventSubjectJavaFileHandle, curNode);
    }

    void addJavaSnippetOfEvent(YangNode curNode, YangPluginConfig pluginConfig) throws IOException {
        String currentInfo = YangIoUtils.getCamelCase(curNode.getName(), pluginConfig.getConflictResolver());
        String notificationName = curNode.getName();
        JavaQualifiedTypeInfoTranslator qualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(curNode, YangIoUtils.getCapitalCase(currentInfo));
        JavaAttributeInfo javaAttributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, currentInfo, null, false, false);
        this.addEventEnum(notificationName);
        this.addEventSubjectAttribute(javaAttributeInfo);
        this.addEventSubjectGetter(javaAttributeInfo);
        this.addEventSubjectSetter(javaAttributeInfo, currentInfo);
    }

    private void addEventEnum(String notificationName) throws IOException {
        this.appendToFile(this.getEventEnumTempFileHandle(), JavaDocGen.enumJavaDocForInnerClass(notificationName) + "        " + JavaIdentifierSyntax.getEnumJavaAttribute(notificationName).toUpperCase() + "," + "\n");
    }

    private void addEnumMethod(String eventClassname, String className) throws IOException {
        this.appendToFile(this.getEventMethodTempFileHandle(), TempJavaEventFragmentFiles.getEventFileContents(eventClassname, className));
    }

    private void addEventSubjectAttribute(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getEventSubjectAttributeTempFileHandle(), this.parseAttribute(attr));
    }

    private void addEventSubjectGetter(JavaAttributeInfo attr) throws IOException {
        String appDataStructure = null;
        if (attr.getCompilerAnnotation() != null) {
            appDataStructure = attr.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        this.appendToFile(this.getEventSubjectGetterTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, attr.getAttributeName(), false, appDataStructure) + MethodsGenerator.getGetterForClass(attr, 1024) + "\n");
    }

    private void addEventSubjectSetter(JavaAttributeInfo attr, String className) throws IOException {
        String appDataStructure = null;
        if (attr.getCompilerAnnotation() != null) {
            appDataStructure = attr.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        this.appendToFile(this.getEventSubjectSetterTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.MANAGER_SETTER_METHOD, attr.getAttributeName(), false, appDataStructure) + MethodsGenerator.getSetterForClass(attr, className, 1024) + "\n");
    }

    private File getJavaFileHandle(YangNode curNode, String name) {
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        return JavaFileGeneratorUtils.getFileObject(this.getDirPath(parentInfo), name, JAVA_FILE_EXTENSION, parentInfo);
    }

    private String getDirPath(JavaFileInfoTranslator parentInfo) {
        return (parentInfo.getPackageFilePath() + UtilConstants.SLASH + parentInfo.getJavaName()).toLowerCase();
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.eventJavaFileHandle, isErrorOccurred);
        FileSystemUtil.closeFile(this.eventListenerJavaFileHandle, isErrorOccurred);
        FileSystemUtil.closeFile(this.eventSubjectJavaFileHandle, isErrorOccurred);
        FileSystemUtil.closeFile(this.eventEnumTempFileHandle, true);
        FileSystemUtil.closeFile(this.eventSubjectAttributeTempFileHandle, true);
        FileSystemUtil.closeFile(this.eventMethodTempFileHandle, true);
        FileSystemUtil.closeFile(this.eventSubjectGetterTempFileHandle, true);
        FileSystemUtil.closeFile(this.eventSubjectSetterTempFileHandle, true);
        super.freeTemporaryResources(isErrorOccurred);
    }
}

